/****************************************************************************/
/*                                                                          */
/* SVSH.H: Software Video Stream Handler Common Definitions.                */
/*                                                                          */
/* Copyright (c) IBM Corporation 1991,1992,1993        All Rights Reserved  */
/*                                                                          */
/****************************************************************************/

/* XLATOFF */
#pragma pack(4)
/* XLATON */

/************************** SVSH_MESSAGES ***********************************/
/*                                                                          */
/* The SpiSendMessage API is used to send messages to stream instances.     */
/* Each of these messages has a HID and HSTREAM to route the message to the */
/* correct stream handler.  Message is routed to the stream manager sent    */
/* in the following format:                                                 */
/*                                                                          */
/* SpiSendMessage (hstream, hid, ulMesagetype, pMsg)                        */
/*                                                                          */
/* The ulMessage type is one of the SVSH_xxx #defines below and the pMsg    */
/* message pointer points to the corresponding data structure accompanying  */
/* the message.                                                             */
/*                                                                          */
/* The message must contain a message length indicator as its first element */
/* so that the SSM can validate it.                                         */
/*                                                                          */
/* The following structures define the contents of the pMsg structure       */
/* for each of the ulMsgType fields.  all of the ulMsgTtpes are defines a   */
/* SVSH_xxx where xxx indicates the actual message.                         */
/*                                                                          */
/****************************************************************************/
#define SVSH_ASYNC_PALETTE                1L
     typedef struct _PARM_SVSH_ASYNC_PALETTE { /* parmplt */
       ULONG       ulMsgLen;           /* Input - length of structure  */
       GENPAL      genpalPhysical;     /* reserved field for use in future apps - NULL */
     } PARM_SVSH_ASYNC_PALETTE;

typedef PARM_SVSH_ASYNC_PALETTE *PPARM_SVSH_ASYNC_PALETTE;


/******************************************************/
#define SVSH_ASYNC_VALID_RECTS          2L
     typedef struct _PARM_SVSH_ASYNC_VALID_RECTS { /* parmir */
       ULONG      ulMsgLen;             /* Input - length of structure  */
       ULONG      ulNumRects;           /* Input - number of valid rects (0 => focus) */
       PRECTL     prectlArray;          /* Input - Pointer to array of rectangles */
     } PARM_SVSH_ASYNC_VALID_RECTS;

typedef PARM_SVSH_ASYNC_VALID_RECTS *PPARM_SVSH_ASYNC_VALID_RECTS;


/******************************************************/
#define SVSH_NEWHWND                     3L
     typedef struct _PARM_SVSH_NEWHWND { /* parmnwh */
       ULONG      ulMsgLen;             /* Input - length of structure  */
       HWND       hwnd;                 /* new window handle */
       HAB        hab;                  /* application or default window HAB */
     } PARM_SVSH_NEWHWND;

typedef PARM_SVSH_NEWHWND *PPARM_SVSH_NEWHWND;


/******************************************************/
#define SVSH_QUERY_STATUS                 4L
     typedef struct _PARM_SVSH_QUERY_STATUS { /* parmqs */
       ULONG      ulMsgLen;             /* Input  - length of structure  */
       ULONG      ulFrameNumber;        /* Output - the current frame number */
       ULONG      ulCodecCapsFlags;     /* Output - pluggable decompressor caps */
       BOOL       fDirectMode;          /* Output - indicates if direct or PM screen update used */
     } PARM_SVSH_QUERY_STATUS;

typedef PARM_SVSH_QUERY_STATUS *PPARM_SVSH_QUERY_STATUS;


/******************************************************/
#define SVSH_RECTL_COORDS                 5L
     typedef struct _PARM_SVSH_RECTL_COORDS { /* parmrc */
       ULONG     ulMsgLen;       /* Input - length of structure             */
       ULONG     ulFlag;         /* Input - set to QUERY_RECTS or SET_RECTS */
                                 /* MCI_PUT or MCI_WHERE dependant          */
       RECTL1    rectlSrc;       /* Input Source rectangle rel to desktop   */
       RECTL1    rectlDst;       /* the destination rect relative to dsktop */
     } PARM_SVSH_RECTL_COORDS;

typedef PARM_SVSH_RECTL_COORDS *PPARM_SVSH_RECTL_COORDS;

/* ulFlag  Defines:                                                         */
#define SET_RECTS           0x0000L       /* change the current rects       */
#define QUERY_RECTS         0x0001L       /* return data to the caller      */


/******************************************************/
#define SVSH_SET_FRAME_INTERVAL           6L
     typedef struct _PARM_SVSH_SET_FRAME_INTERVAL { /* parmsfi */
       ULONG    ulMsgLen;              /* length of structure in bytes */
       MMTIME   mmtimeFrameInterval;   /* the new frame interval in chinatown units */
       BOOL     fSyncClockOff;         /* Turn off sync clock - SCAN mode */
       ULONG    ulReserved1;           /* Reserved for future use */
       ULONG    ulReserved2;           /* Reserved for future use */
       ULONG    ulReserved3;           /* Reserved for future use */
     } PARM_SVSH_SET_FRAME_INTERVAL;

typedef PARM_SVSH_SET_FRAME_INTERVAL *PPARM_SVSH_SET_FRAME_INTERVAL;

/******************************************************/
#define SVSH_RECTLS_AND_VRNS              7L
     typedef struct _PARM_SVSH_RECTLS_AND_VRNS { /* parmrv */
       ULONG    ulMsgLen;             /* Input - length of structure    */
       ULONG    ulFlags;              /* Input - see flag defines below */
       RECTL1   rectlSrc;             /* source rect (desktop co-ords)  */
       RECTL1   rectlDst;             /* dest rect (desktop co-ords)    */
       ULONG    ulNumRects;           /* Input - number of valid rects  */
       PRECTL   prectlArray;          /* Input - Pointer to array of vis rects */
     } PARM_SVSH_RECTLS_AND_VRNS;

typedef PARM_SVSH_RECTLS_AND_VRNS *PPARM_SVSH_RECTLS_AND_VRNS;


/******************************************************/
#define NUM_SVSH_MESSAGES                 7L


/******************************************************/
/*                                                    */
/* ACB_DIGVID - Digital Video Specific associate      */
/*              control block                         */
/*                                                    */
/******************************************************/

#define ACBTYPE_DIGVID        0x0001L  /* DIGVID object */
typedef struct _acb_digvid    { /* acbdigvid  - DIGVID Assoc. Control Block */
   ULONG           ulACBLen;         /* length of structure */
   ULONG           ulObjType;        /* ACBTYPE_DIGVID */
   PMMIOINFO       pmmioinfo;        /* pointer to the mmio info struct */
   PVOID           pVideoStore;      /* video ram store */
   PMMVIDEOHEADER  pmmvideoHeader;   /* Ptr to video specific information */
   RECTL1          rectlSrc;         /* Source rectangle rel to desktop */
   RECTL1          rectlDst;         /* the destination rectangle rel to desktop */
   BOOL            fMonitorMode;     /* @JC01 use direct calls to mon window */
   ULONG           ulColorEncoding;  /* @JC01 source monitor data format */
   } ACB_DIGVID;
typedef ACB_DIGVID     *PACB_DIGVID; /* Ptr to an ACB  */

/* define some stuff for the PM mode for super VGA machines */
#define ID_DO_REFRESH               0x3b29   /* define for the synchronous blit */

/********** DCR 96 and Aperture stuff *****************/
#define DEVESC_GETAPERTURE 33000L
#define DEVESC_ACQUIREFB   33010L
#define DEVESC_DEACQUIREFB 33020L
#define DEVESC_SWITCHBANK  33030L

/******************************************************/
/* APERTURE - Aperture definition for the hardware    */
/*            this will eventually disappear as soon  */
/*            as header file is published             */
/******************************************************/
typedef struct _APERTURE {  /* aperture */
      ULONG ulPhysAddr;       /* physical address */
      ULONG ulApertureSize;   /* 1 Meg, 4 Meg or 64k */
      ULONG ulScanLineSize;   /* this is >= the screen width */
      RECTL rctlScreen;       /* device independant co-ordinates */
} APERTURE;

typedef APERTURE FAR *PAPERTURE;

/******************************************************/
/* ACQUIREFB - Acquire Frame buffer devescape         */
/*             structure (eventually in a PM          */
/*             header file pmdev.h)                   */
/******************************************************/
typedef struct _ACQUIREFB { /* acquirefb */
     ULONG  fAFBFlags;
     ULONG  ulBankNumber;
     RECTL  rctlXRegion;
} ACQUIREFB;

typedef ACQUIREFB *PACQUIREFB;

/*********************************/
/* Bit definitions for fAFBFlags */
/*********************************/
#define AFB_SWITCH 1

/* structure for DEVESC_SWITCHBANK */
typedef struct _SWITCHBANK {  /* switchbank */
   ULONG ulBankNum;
} SWITCHBANK;
typedef SWITCHBANK *PSWITCHBANK;

/* tstcfg driver onterface flags */
#define TESTCFG_DRIVER_CLOSE  0x0000
#define TESTCFG_DRIVER_OPEN   0x0001

/* define maximum number of microchannel slots */
#define MAX_MCA_SLOTS         8

/* define io register stuff for XGA planar and POS registers */
#define POS_DATA_REG          0x0100   // base address from where pos data read
#define POS_SELECT_REG        0x0096   // select reg for the pos regs
#define PLANAR_SELECT_REG     0x0094   // select the planar board
#define VIDEO_SUBSYS_DESELECT 0x00FF   // select the video subsystem on planar
#define VIDEO_SUBSYS_SELECT   0x00DF   // deselect video subsystem

/* define adaptor card types (POS_ID) */
#define XGA_4_ADAPTOR         0x8FD8   // for the xga 4 subsystems
#define XGA_3_ADAPTOR         0x8FD9   // for the P2
#define XGA_1_ADAPTOR         0x8FDB   // note db = pos0 8f = pos1
#define XGA_2_ADAPTOR         0x8FDA   // for the xga 2 subsystems

/* define interfaces to TESTCFG.SYS */
#define TESTCFG_CATEGORY      0x80

/* define the ioctl functions */
#define TESTCFG_GETBIOSMEM_FN 0x40
#define TESTCFG_IN_FN         0x41
#define TESTCFG_OUT_FN        0x42
#define TESTCFG_QUERYBUS_FN   0x60
#define TESTCFG_QUERYPOS_FN   0x61

/* TESTCFG_QUERYBUS_FN return types */
#define BUSTYPE_ISA              0
#define BUSTYPE_MCA              1
#define BUSTYPE_EISA             2

/* define ulFlag for the port Call_IO function */
#define READ_IO                  0
#define WRITE_IO                 1

/* define ulSize for the port Call_IO function */
#define SIZE_BYTE                1
#define SIZE_WORD                2
#define SIZE_DWORD               4

/* parameter packet definition for the Query bus type IOCtl */
typedef struct _PARAM_QBT { /* qbt */
   ULONG comand;
} PARAM_QBT;

/* XLATOFF */
#pragma pack()
/* XLATON */

