/****************************************************************************/
/*                                                                          */
/* SAMPINST.H: Sample Coded instance data definitions.                      */
/*                                                                          */
/* Copyright (c) IBM Corporation 1991,1992,1993        All Rights Reserved  */
/*                                                                          */
/****************************************************************************/

#pragma pack(4)

/* This structure holds information specific to your compression.           */
typedef struct _encode_inst
   {
   ULONG  ulWidth;           /* The frame width.                            */
   ULONG  ulHeight;          /* The frame height.                           */
   ULONG  ulColorEncoding;   /* The color format of the source data.        */
   PBYTE  pbLastFrame;       /* Compressor allocated pointer to last frame. */
   ULONG  ulKeyFrameInterval;/* # of frames within which there is 1 I frame.*/
   ULONG  ulKeyFrameCounter; /* # of frames left before we need to do an I. */
   }  ENCODE_INST;
typedef ENCODE_INST *PENCODE_INST;


/* This structure holds information specific to your decompression.         */
typedef struct _decode_inst
   {
   BOOL   fFirstTime;        /* Support flag for multiple aperture decode.  */
   ULONG  ulMovieWidth;      /* Width of the movie.                         */
   ULONG  ulMovieHeight;     /* Height of the movie.                        */
   PBYTE  pbCompressedData;  /* Holds coded data pointer between svga calls.*/
   ULONG  ulNumColors;       /* The number of colors in the output plane.   */
   PBYTE  pbClipMask;        /* Codec specific clipping mask.               */
   }  DECODE_INST;
typedef DECODE_INST *PDECODE_INST;


/* This structue is the main instance structure.  It holds a pointer to     */
/* either an encode structure, a decode structure, or both, but not neither.*/
typedef struct _main_inst
   {
   PENCODE_INST pEncodeInst;
   PDECODE_INST pDecodeInst;
   } MAIN_INST;
typedef MAIN_INST *PMAIN_INST;


#pragma pack()
