/*********************************************************************/
/*                                                                   */
/*  FILE NAME:              RESETINI.CMD                             */
/*                                                                   */
/*  AUTHOR:                 Jeffrey S. Kobal (AKA Psycho Murdoctor)  */
/*                                                                   */
/*  DATE:                   May 12, 1993                             */
/*                                                                   */
/*  PURPOSE:                Reset default Multimedia connections     */
/*                                                                   */
/*********************************************************************/

/*********************************************************************/
/* Load the DLL, initialize MCI REXX support                         */
/*********************************************************************/

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Set Volume to Maximum (100) */
   call SendString "masteraudio volume 100"

/* Break all cdaudio streaming connections */
   call SendString "defaultconnection cdaudio break type cd stream wait"
   call SendString "defaultconnection cdaudio01 break type cd stream wait"
   call SendString "defaultconnection cdaudio02 break type cd stream wait"
   call SendString "defaultconnection cdaudio03 break type cd stream wait"

/* Break all CDXA streaming connections */
   call SendString "defaultconnection cdxa break type xa stream wait"
   call SendString "defaultconnection cdxa01 break type xa stream wait"
   call SendString "defaultconnection cdxa02 break type xa stream wait"
   call SendString "defaultconnection cdxa03 break type xa stream wait"

/* Connect all waveaudio devices to respective audio devices */
/* The default "waveaudio" device is connected to the first audio device */
   call SendString "defaultconnection waveaudio make type wave stream to ampmix01 totype amp stream wait"
   call SendString "defaultconnection waveaudio01 make type wave stream to ampmix01 totype amp stream wait"
   call SendString "defaultconnection waveaudio02 make type wave stream to ampmix02 totype amp stream wait"
   call SendString "defaultconnection waveaudio03 make type wave stream to ampmix03 totype amp stream wait"
   call SendString "defaultconnection waveaudio04 make type wave stream to ampmix04 totype amp stream wait"
   call SendString "defaultconnection waveaudio05 make type wave stream to ampmix05 totype amp stream wait"

/* Connect all sequencer (MIDI) devices to respective audio devices */
   call SendString "defaultconnection sequencer make type midi stream to ampmix01 totype amp stream wait"
   call SendString "defaultconnection sequencer01 make type midi stream to ampmix01 totype amp stream wait"
   call SendString "defaultconnection sequencer02 make type midi stream to ampmix02 totype amp stream wait"
   call SendString "defaultconnection sequencer03 make type midi stream to ampmix03 totype amp stream wait"
   call SendString "defaultconnection sequencer04 make type midi stream to ampmix04 totype amp stream wait"
   call SendString "defaultconnection sequencer05 make type midi stream to ampmix05 totype amp stream wait"

/* Connect all digital video devices to first audio device */
   call SendString "defaultconnection digitalvideo make type wave stream to ampmix01 totype amp stream wait"
   call SendString "defaultconnection digitalvideo01 make type wave stream to ampmix01 totype amp stream wait"
   call SendString "defaultconnection digitalvideo02 make type wave stream to ampmix01 totype amp stream wait"

/*********************************************************************/
/* Terminate the REXX command file and Exit (DLL), return code = 0.  */
/*********************************************************************/

                      /****************************************/
MacRC = mciRxExit()   /* Terminate REXX command file          */
exit 0                /* Tell the DLL we're going away        */
                      /****************************************/

/*********************************************************************/
/*   --- SendString --                                               */
/* Call DLL function.  Pass the command to process and the           */
/* name of a REXX variable that will recieve textual return          */
/* information.                                                      */
/*********************************************************************/

SendString:
   arg CmndTxt
   Zero='0'
   MacRC = mciRxSendString(CmndTxt, 'RetSt', Zero, Zero)
   return MacRC

