/****************************************************************************/
/*                                                                          */
/* CODECSRV.H: Common Codec Service Definitions                             */
/*                                                                          */
/* Copyright (c) IBM Corporation 1991,1992,1993        All Rights Reserved  */
/*                                                                          */
/****************************************************************************/

/********************************************************/
/* E_MOVIE_INST - one per movie instance, pointer to    */
/*                this is stored in each hcodec, the    */
/*                anchor is stored so that all hCocec   */
/*                instances can be destroyed in the     */
/*                case of an error                      */
/********************************************************/
typedef struct _E_MOVIE_INST {      /* e_movie_inst */
   ULONG          ulNumCodecs;      /* number of compression types attached */
   PVOID          pCodecInstAnchor; /* pointer to the linked list of codec's*/
   CODECOPEN      codecopen;        /* shared static data movie height, width etc */
} E_MOVIE_INST;
typedef E_MOVIE_INST *PE_MOVIE_INST;

/********************************************************/
/* CODEC_INST - A Per Codec instance data pointer.      */
/*              hCodec points to one of these structs.  */
/********************************************************/
typedef struct _CODEC_INST { /* cdi */
   PVOID          pCodecPlugInstData;  /* compression format specific data pointer */
   PE_MOVIE_INST  pe_movie_inst;       /* shared movie data */
   struct         _CODEC_INST *pNextCodecInst;  /* linked list for a movie */
}  CODEC_INST;
typedef CODEC_INST *PCODEC_INST;

/********************************************************/
/* QUERYLEN - Cast this structure to generic structures */
/*            that have a length as their first field.  */
/*            This is used for allocating memory        */
/********************************************************/
typedef struct _QUERYLEN { /* qrylen */
   ULONG       ulStructLen;
}  QUERYLEN;
typedef QUERYLEN *PQUERYLEN;

/********************************************************/
/* Codec specific function defines:                     */
/* the specific entrypoints for this codec are defined  */
/* in the global data C file for the appropriate codec  */
/********************************************************/
typedef struct _CODECFNS {
   PFN   pfnAllocInstData;    // Allocation function pointer
   PFN   pfnDeallocInstData;  // Cleanup function pointer
   PFN   pfnPaletteHandler;   // palette handling logic
   PFN   pfnClipHandler;      // clipping calculator
   PFN   pfnDecompressBuffer; // Decompress buffer entry
   PFN   pfnCompressBuffer;   // Compress buffer entry
   PFN   pfnQryNameLength;    // specific codec name length
   PFN   pfnQryNameString;    // specific codec name string
} CODECFNS;
typedef CODECFNS *PCODECFNS;
extern CODECFNS codecfns;     // ensure that the fns can be called from common code

/********************************************************/
/* define common code function prototypes               */
/********************************************************/
RC RemoveCodecChainLink    ( PCODEC_INST );
RC OpenCodec               ( PCODEC_INST *, PCODECOPEN);
RC CloseCodec              ( PCODEC_INST * );
RC QryNameLength           ( PVOID   ppcodec_inst,
                             WORD    wMessage,
                             PULONG  pulLength,
                             LONG    lParam2 );

RC QryNameString           ( PVOID  ppcodec_inst,
                             WORD   wMessage,
                             PSZ    pszCODECNameNew,
                             PULONG pulLength );

RC CalcClippingMask        ( ULONG  ulNumValidRects,
                             PRECTL prectlArray,
                             PRECTL prectlSrc,
                             RECTL  rectlDst,
                             ULONG  ulBlockLength,
                             PBYTE  pbClipMask,
                             ULONG  ulBlockWidth,
                             ULONG  ulBlockHeight,
                             ULONG  ulMaskLength,
                             ULONG  ulMaskWidth);

/* prototype the DLL init-term interface that is called from codecsrv.c */

ULONG _DLL_InitTerm( HMODULE hmod, ULONG fTerm);

#define UNCLIPPED                   0x00
#define CLIPPED                     0x01

/********************************************************/
/* Macro definitions                                    */
/********************************************************/
#define     ENTERCRITX(rc)   if (rc = DosRequestMutexSem(hmtxGlobalData, SEM_INDEFINITE_WAIT)) return(rc);
#define     ENTERCRIT(rc)    (rc = DosRequestMutexSem(hmtxGlobalData, SEM_INDEFINITE_WAIT))
#define     EXITCRIT         (DosReleaseMutexSem(hmtxGlobalData))
#define     HEAP_SIZE        4096L

/********************************************************/
/* Process Instance global data references              */
/********************************************************/
extern      HHUGEHEAP  hHeap;
extern      HMTX       hmtxGlobalData;  /* Critical section semaphore */

