Below is private header file information for the Asymmetric Recording
Sample function code.

typedef struct
  {
   ULONG         ulChunkID;        /* ID for this chunk                     */
   ULONG         ulChunkLength;    /* Length of chunk that follows          */
   USHORT        usTrackNumber;    /* Video track number(0L only for now)   */
   ULONG         ulDuration;       /* Frame duration in MMTIME              */
   ULONG         ulFrameFlags;     /* Frame flags                           */
   ULONG         ulCompressionType;/* Compression type                      */
  } VFHTEMPLATE;

typedef struct _RECCB                /* Record control block                */
  {
   HEV       hevRecordPaused; /* Event semaphore handle for paused recording*/
   HEV       hevFrameStep;
   HEV       hevLiveMonitorEnabled;
   HFILE     hRawFile;               /* Raw video file handle               */

   BYTE      * streambuf;            /* Output stream buffer                */
   BYTE      * rawimagebuf;          /* Pointer to raw image buffer         */
   BYTE      * compimagebuf;         /* Pointer to compressed image buffer  */

   VFHTEMPLATE vfhtTemplate;

   ULONG     ChapterDuration;
   ULONG     ChapterMinFrameSize;
   ULONG     ChapterMaxFrameSize;
   ULONG     CompressionRatioX100;
   ULONG     outbuflen;              /* Number of bytes in output buffer    */

   USHORT    usImgCaptX;             /* Width of capture destination rect   */
   USHORT    usImgCaptY;             /* Height of capture destination rect  */

   ULONG     FramesCounted;
   BOOL      fStillRunning;

   DWORD     dwSrcCurrentPosition;   /* Position of current source          */
   DWORD     dwMovieRecordFrom;      /* Record from position                */
   DWORD     dwMovieRecordTo;        /* Record to position                  */
   DWORD     dwMovieCurrentPosition;

   BOOL      fAudioFileOpen;
   HFILE     hVideoFile;       /* Video file handle                         */
   TID       RecordThreadID;   /* Thread ID for asymetric recording thread  */
   TID       WriterThreadID;   /* Thread ID for file output thread          */
   ULONG     FileOutSize;      /* Holds the entire length of the output file*/
   ULONG     chapterbytes;     /* Number of bytes written for chapter       */
  } RECCB;
typedef RECCB * PRECCB;


/*************************************/
/*          Global Defines           */
/*************************************/

#define  TEMP_VIDEO_FILENAME    "AVIFILE.AVI"

/***********************/
/* CODEC list          */
/***********************/
typedef struct _CODEC_DATA
{
  CHAR                 szCODECName[CCHMAXPATH];/* codec name for display     */
  CODECINIFILEINFO     cifi;                   /* codec ini file information */
  struct _CODEC_DATA   *pNext;                 /* next codec in list         */
} CODEC_DATA, *PCODEC_DATA;

typedef struct _RECOPTS
  {
  USHORT SrcFPS;
  USHORT MovieFPS;
  BOOL   fInsertRefFrames;
  USHORT usMaxRefreshTime;
  BOOL   fRealTime;
  BOOL   fCompress;
  USHORT usCapPosX;
  USHORT usCapPosY;
  USHORT usCapSizeX;
  USHORT usCapSizeY;
  USHORT usUserCapSizeX;
  USHORT usUserCapSizeY;
  USHORT usZoomSetting;
  USHORT usMaxDataRate;
  USHORT usQuality;

/**************************************************************************/
/* usMovieSizeX = 320, usMovieSizeY = 240                                 */
/* This is half the capture size.  In the recorder application this would */
/* be a 2 to 1 zoom.                                                      */
/**************************************************************************/
  USHORT usMovieSizeX;
  USHORT usMovieSizeY;
  USHORT usMaxVideoSizeX;
  USHORT usMaxVideoSizeY;
  } RECOPTS;

/*******************************************************/
/* Control block structure for "global" values.        */
/*******************************************************/

typedef struct _SWVRCB
{
  /*********************************/
  /** data for input and output   **/
  /*********************************/
  MOVIE_MODE_DATA  OutputMovie;           /* Movie data                      */
  MOVIE_MODE_DATA  InputMovie;            /*Source data                      */

  /*************************/
  /** User interface data **/
  /*************************/
  HAB              hab;                   /* anchor block handle             */

  /** Recording Data     **/
  RECOPTS          recopts;               /* Record options structure        */
  PVOID            pRecCB;                /* Pointer to recording CB         */
  HFILE            CaptureDevHandle;  /* File handle for image capture device*/
  DWORD            dwSrcRecordFrom;       /* Media positions from marks ...  */
  DWORD            dwSrcRecordTo;
  ULONG            ulImageX;              /* Movie image sizes               */
  ULONG            ulImageY;
  TID              MonitorThreadID;      /* Thread ID for live monitor thread*/
  WORD             wWaveDID;              /* audio capture device ID         */
  WORD             wExtdevDID;            /* external video source ID        */

  /****************/
  /** Flags      **/
  /****************/
  BOOL             fHourGlass;            /* Are we waiting?                 */
  BOOL             fRecordActive;         /* recording in progress indicator */
  BOOL             fRecordPaused;         /* recording paused flag           */
  BOOL             fSourceControlled;

  /****************/
  /** Strings    **/
  /****************/
  CHAR             szMovieTitle[CCHMAXPATH];  /* Movie title                 */
  CHAR             szPath[CCHMAXPATH];        /*  default path for files     */
  CHAR             AudioFilename[CCHMAXPATH]; /* file for saving audio       */
  CHAR             szFileName[CCHMAXPATH];    /* Source device file name     */
  CHAR             szRecordSetup[100];  /* Title for record options notebook */

  /*********************/
  /*** Miscellaneous ***/
  /*********************/
  HMMIO            hmmioTemp;
  PCODEC_DATA      pCODECData;            /* Codec chosen                    */
  PCODEC_DATA      pCODECList;          /* Codec list of all available codecs*/
} SWVRCB, *PSWVRCB;
