/*         Create an OS/2 2.1 Boot Diskette & the Perfomance 2.1 Utility Diskette           */
/*                          Copyright (c) 1992, 1993 CLEAR & SIMPLE, INC.                                */
ECHO OFF

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
'mode co80,25'
objectName='O S 2 B O O T . C M D'
call initVariables
call welcome
pos=SysCurPos(0,0)
'cls'
pos=SysCurPos(0,0)

say 'This program will create a bootable diskette for OS/2 2.1.'

SAY GREEN;Say  '  Label it "PERFORMANCE 2.1 OS/2 BOOT Diskette"';SAY BLUE;say ' '
say 'It will also (optionally) create a second diskette containing several'
say 'utility functions that can only be run when you are booted from the'
say 'Boot Diskette.';SAY GREEN;SAY'  Label it the "PERFORMANCE 2.1 UTILITY Diskette".';SAY BLUE;
say 'See the Software Chapter in the Booklet for more information.'
say ' '
say 'You will need up to two (2) blank, formatted, High Density 3.5" diskettes.'
say '(one for the OS/2 Boot Diskette and one for the Utility Diskette.)'
say '    (or one 2.88MB diskette) '
say 'You will also need the OS/2 2.1 INSTALLATION diskette and OS/2 2.1- Diskette 1'
say 'if you want to build an OS/2 Boot Diskette.'
SAY;SAY RED;say 'Do you have the necessary items and wish to continue? (Y/N) ';SAY BLUE
parse upper pull ans1 .
if ans1 \= 'Y' then do
   say 'No diskettes will be created, per your request!'
   say ' '; say 'Press Enter to End this Object'; pull
exit
end   
else NOP

todrive = ' '
pctype = ' '

CALL getBOOT /* Use OS2ENVIRONMENT to find out  the boot drive */

say ' '
say ' But first, I need some information from you!'
say ' '
say 'Please enter the diskette drive letter (e.g., "A", "B", etc.) '
say 'where you want me to create the diskette(s).'
say '(or just press Enter for the default of "A"):'
pull todrive
if todrive = ' ' then todrive = 'A'
else if datatype(todrive,'M') = 0 then do
   say 'You MUST enter a valid drive letter (or Enter). Please try again.'
   pull
   exit
   end   
else NOP
todrive = todrive||':'

say 'What type of machine do you have?'
say '   1 = ISA (AT bus) or EISA bus'
say '   2 = Microchannel (IBM PS/2 M55 or larger) (default)'
pull pctype
if pctype = ' ' then pctype = '2'
else NOP
if (pctype \= '1')&(pctype \= '2') then do
   say 'You MUST enter either '1', '2' or blank. Please try again.'
   pull
   exit
end  
else NOP

say ' '
say ' Do you wish to build an OS/2 boot diskette? (Y/N)'
parse upper pull bdisk .
if bdisk \= 'Y' then do
   say 'No OS/2 boot disk will be created, per your request!'
   call doUtilDisk
   pull
   exit
end  
else NOP

t = 0
do while t = 0
  say ' '
  say 'I will need about 1.3 MB of temporary disk space to build a'
  say 'boot diskette.  Please enter the letter of  the drive where you'
  say 'want me to put the temporary files (e.g., "C", "D", etc.)'
  say '(or just press Enter for the default of your current boot drive):'
  parse upper pull tempdriv
  if tempdriv = ' ' then do 
    tempdriv = Driveis
    t = 1
    end  
  else do
     tempdriv = tempdriv||":"
     map = SysDriveMap('C:', 'LOCAL')
     parse value map with d.1 d.2 d.3 d.4 d.5 d.6 d.7 d.8 d.9
      do d=1 to 9
       if tempdriv = d.d  then t = 1
       else NOP
     end  
  end  
end  


say 'I am now ready to build an OS/2 diskette on' todrive
say 'from' Driveis 'using ' tempdriv 'for temporary space'
if pctype = 2 then say 'for a Microchannel machine'
else say 'for an AT-bus or EISA machine'


/* Is there enough room on the temprary drive? */

info = SysDriveInfo(tempdriv)
parse var info dr free total label
if free < 1300000 then do
    freek = free/1024
    freem = freek/1000
    say 'You must have at least 1.3 MB on your ' tempdrive 'drive to run this utility.'
    say 'You only have' freeM ' MB available.  Please clear some disk space and try again.'
    exit
end   
else NOP

/* Have user put OS/2 INSTALLATION diskette into right drive */
/* and copy the necessary files to a temporary directory on the boot drive. */
say ' '
'MD 'tempdriv'\cands'
b=0
do while b = 0
   note.1 = 262
   note.2 = 523
   note.3 = 262
   note.4 = 523
   do i=1 to 4
      call beep note.i,75
   end  
   SAY 'Please insert the OS/2 V2.1 INSTALLATION DISKETTE in drive 'todrive
   
   'PAUSE'
   say ' '
   call SysFileTree todrive'\OS2LDR.', 'inst'
   b=inst.0
end  

say 'Copying files...'
"COPY" todrive"\OS2KRNL*. " tempdriv"\CANDS\OS2KRNL.* >nul"
"COPY" todrive"\OS2LDR. " tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\SYSINSTX.COM " tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\OS2LDR.MSG "tempdriv"\CANDS\*.* >nul"

/* Now have user put OS/2 DISK 1 in the drive and copy files to boot drive */

say ' '
b=0
do while b = 0
   note.1 = 262
   note.2 = 523
   note.3 = 262
   note.4 = 523
   do i=1 to 4
      call beep note.i,75
   end  
   SAY 'Please insert the OS/2 V2.1 DISKETTE 1 in drive 'todrive
   'PAUSE'
   say ' '
   call SysFileTree todrive'\HARDERR.EXE', 'inst'
   b=inst.0
end 

say 'Copying files...'
"COPY" todrive"\COUNTRY.SYS" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\DOS.SYS" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\PRINT0"pctype".SYS" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\SCREEN0"pctype".SYS" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\KBD0"pctype".SYS" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\CLOCK0"pctype".SYS" tempdriv"\CANDS\*.* >nul"

"COPY" todrive"\HARDERR.EXE" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\SYSINST1.EXE" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\CMD.EXE" tempdriv"\CANDS\*.* >nul"

"COPY" todrive"\ANSICALL.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\B*.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\DOSCALL1.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\KBDCALLS.DLL" tempdriv"\CANDS\*.* >nul"
say 'Still copying files...'
"COPY" todrive"\MOUCALLS.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\VIOCALLS.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\QUECALLS.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\SESMGR.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\OS2CHAR.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\NAMPIPES.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\MSG.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\NLS.DLL" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\NPXEMLTR.DLL" tempdriv"\CANDS\*.* >nul"

"COPY" todrive"\KEYBOARD.DCP" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\SYSLEVEL.OS2" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\OS2DASD.DMD" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\IBMINT13.I13" tempdriv"\CANDS\*.* >nul"
"COPY" todrive"\IBM"pctype"FLPY.ADD" tempdriv"\CANDS\*.* >nul"


/* Now have user put the new boot diskette in the drive */

say ' '
c=1
do while c \= 0
   note.1 = 262
   note.2 = 523
   note.3 = 262
   note.4 = 523
   do i=1 to 4
      call beep note.i,75
   end  
   SAY 'Please insert a blank, formatted diskette for your' 
   SAY 'new boot diskette in drive ' todrive
   'PAUSE'
   say ' '
   call SysFileTree todrive'\*.*', 'boot'
   c=boot.0
        if c\=0 then say 'Diskette is not completely blank, it may have hidden files'
        
end 

/* Make the new diskette bootable and copy the files from the INSTALLATION disk... */
say 'Loading System files...'
tempdriv"\CANDS\SYSINSTX "todrive   /* Make the diskette bootable */

say 'Copying files to new boot diskette...'
"COPY "tempdriv"\CANDS\*.* "todrive" >nul"  /* Copy all they files to the diskette */

say 'Cleaning up temporary files... '
say 'the list of files vary by system type,'
say 'some on our list may not be there on your system...'

'ERASE 'tempdriv'\CANDS\*.EXE >nul'   /* Erase the temporary files */
'ERASE 'tempdriv'\CANDS\*.DLL >nul'
'ERASE 'tempdriv'\CANDS\*.DMD >nul'
'ERASE 'tempdriv'\CANDS\*.SYS >nul'
'ERASE 'tempdriv'\CANDS\OS2*.* >nul'                
'ERASE 'tempdriv'\CANDS\*.DCP >nul'
'ERASE 'tempdriv'\CANDS\*.OS2 >nul'
'ERASE 'tempdriv'\CANDS\*.COM >nul'               

'ERASE 'tempdriv'\CANDS\*.I13 >nul'
'ERASE 'tempdriv'\CANDS\*.ADD >nul'


'RD 'tempdriv'\cands'      /* Remove the temporary directory */

/* Copy HPFS and SCSI files as necessary */

 "COPY "Driveis"\OS2\HPFS.IFS "todrive" >nul"
 "COPY "Driveis"\OS2\OS2SCSI.DMD "todrive" >nul"

/* Create ABIOS.SYS for PS/2s only */

if pctype = '2' then do
   afile = todrive"\ABIOS.SYS"
   call lineout afile, '', 1
   i=lineout(afile)
end   
else NOP

say 'Making CONFIG.SYS for your new boot diskette...'
/* Now create a CONFIG.SYS file of the new boot diskette */
outfile = todrive"\CONFIG.SYS"

call lineout outfile, "REM This CONFIG.SYS created by Clear and Simple, Inc."
call lineout outfile, 'IFS=HPFS.IFS /CACHE:64'
call lineout outfile, 'BUFFERS=32'
call lineout outfile, 'IOPL=YES'
call lineout outfile, 'MEMMAN=NOSWAP'
call lineout outfile, 'PROTSHELL=SYSINST1.EXE'
call lineout outfile, 'SET OS2_SHELL=CMD.EXE'
call lineout outfile, 'DISKCACHE=64,LW'
call lineout outfile, 'PROTECTONLY=YES'
call lineout outfile, 'LIBPATH=.;\;'
call lineout outfile, 'PAUSEONERROR=NO'
call lineout outfile, 'CODEPAGE=850'
call lineout outfile, 'DEVINFO=KBD,US,KEYBOARD.DCP'
call lineout outfile, 'REM DEVINFO=SCR,EGA,VTBL850.DCP'
call lineout outfile, 'DEVICE=\DOS.SYS'
call lineout outfile, 'SET PATH=.;\'
call lineout outfile, 'SET DPATH=\;'
call lineout outfile, 'SET KEYS=ON'
call lineout outfile, 'BASEDEV=PRINT0'pctype'.SYS'
call lineout outfile, 'BASEDEV=IBM'pctype'FLPY.ADD'
if (pctype='1') then call lineout outfile, 'BASEDEV=IBM1S506.ADD'
else NOP
call lineout outfile, 'BASEDEV=OS2SCSI.DMD'
call lineout outfile, 'BASEDEV=IBMINT13.I13'
call lineout outfile, 'BASEDEV=OS2DASD.DMD'
call lineout outfile
DROP outfile

say ' '
say 'OS/2 2.1 Boot Diskette successfully created.'

call doUtilDisk

/* Clean up and get out */

call SysDropFuncs
say ' '
say 'Your new PERFORMANCE 2.1 Diskette(s) have been'
say 'successfully created - just as you requested!'
say '        - by -'
say 'CLEAR & SIMPLE, INC.'
SAY ' '
say '* * * * * * * * * * * * * * * * * * * * * * * *'
say '*   WE HIGHLY RECOMMEND THAT YOU REBOOT NOW   *'
SAY '*   USING YOUR NEW BOOT DISKETTE!             *'
SAY '*   WHEN YOU DO, RUN THE SAVECNFG UTILITY,    *'
SAY '*   LOCATED ON THE PERFORMANCE 2.1 UTILITY DISKETTE *'
SAY '*   THIS WILL SAVE  CRITICAL OS2 FILES        *'
SAY '*   WHICH WILL BE NEEDED IF YOU EVER HAVE A   *'
SAY '*   FAILURE OF THE OS/2 WORKPLACE SHELL.      *'
SAY '*   YOU MIGHT AVOID HAVING TO REINSTALL OS/2  *'
SAY '*   FROM SCRATCH ! ! ! ! ! ! !                *'
SAY '* * * * * * * * * * * * * * * * * * * * * * * *'

say ' '; say 'Press Enter to End this Object'
pull
exit



doUtilDisk:
say 'Do you want me to create a "Performance 2.1" Utility Diskette? (Y/N)'
parse upper pull chk1 .
if chk1 \= 'Y' then do
        say ' '; say 'Are you sure?  This is highly recommended!'
        say ' '; say 'Last chance to make a Utility diskette? (Y/N)'; pull chk1
        if chk1 \= 'Y' then do
                say 'I will NOT create a Utility Diskette.'
                say 'CLEAR & SIMPLE, INC.'
                 return
                        end   
        else NOP
        end
say ' '
c=1
do while c \= 0
   note.1 = 262
   note.2 = 523
   note.3 = 262
   note.4 = 523
   do i=1 to 4
      call beep note.i,75
   end  
   SAY 'Please insert a second blank, formatted diskette which will'
   SAY 'become the Utility Diskette in drive ' todrive
   'PAUSE'
   say ' '
   call SysFileTree todrive'\*.*', 'chck'
   if chck.0 \=0 then do; say 'diskette is not completely blank - it may have hidden files'
      say 'We will assume there is enough room'
        say '(ctrl-break) can stop the copies'
end   
   
   c=0
end  
say red;say 'Copying CHKDSK.COM to the Utility Diskette...'
/* Put the CHKDSK stuff on the Utility Diskette */
"COPY" Driveis"\OS2\CHKDSK.COM "todrive' >NUL'
"COPY" Driveis"\OS2\SYSTEM\OSO001.MSG "todrive' >NUL'
"COPY" Driveis"\OS2\DLL\UHPFS.DLL "todrive' >NUL'
say green;Say 'Copying CONFIG.SYS to ORIGINAL.SYS on the Utility Diskette...'
"COPY" Driveis"\CONFIG.SYS "todrive"\ORIGINAL.SYS"' >NUL'

say red;Say 'Copying PERFORMANCE 2.1 Utilities to the diskette...'

call SysFileTree 'os2boot.cmd', 'info', 'F'
parse upper var info.1 cdate ctime fsize attribs wherefile
parse var Wherefile Wdrive ':\' Wdir '\OS2BOOT.CMD'
wdrive=right(wdrive,1)
P2LOC=WDRIVE':\'WDIR

'COPY' P2LOC"\UTILp21\*.CMD" todrive' >NUL'

say blue;say;say ' '; say 'PERFORMANCE 2.1 Utility diskette Created!'


return


getBOOT:
bootdrive = Value('Path',,'OS2ENVIRONMENT')
parse upper var bootdrive bootdrive
Driveis = Substr(bootdrive,Pos('\OS2\SYSTEM',bootdrive)-2,2)
return

Welcome:
echo on
'prompt $p$E[0;'34';'47';'5';'5'm]'
echo off
'cls'
call SysCurState 'OFF'
call sysCurPos '4', '0'

msg.0 =12
msg.1 = blue
msg.2 = cr5 cr5' Ŀ'
msg.3 = cr5 cr5'                                  '
msg.4 = cr5 cr5'   P E R F O R M A N C E   2.1   '
msg.5 = cr5 cr5'                                       '
msg.6 = cr5 cr5'                                 '
msg.7 = cr5 cr5'                                 '
msg.8 = cr5 cr5'                                 '
msg.9 = cr5 cr5'                                 '
msg.10 = cr5 cr5' '
msg.11 = hblue
msg.12 = cr5 '        Copyright (c) 1993 Clear & Simple, Inc.           '

msg.13= '         Please Maximize SCREEN SIZE  & Press Enter to Continue    '
do i =1  to msg.0
       say msg.i
       end
call SysCurPos '19','0'

 
say red;
call sysCurPos '7', '22'
call syssay ''
call sysCurPos '8', '21'
call syssay ''


say;
 
say red;
call sysCurPos '9', '21'
call syssay 'Go'
 

call sysCurPos '9', '23'
call syssay ' as fast as'
 

call sysCurPos '9', '35'
call syssay '32 bits'
 

call sysCurPos '11', '30'
call syssay ' will'
 

call sysCurPos '11', '35'
call syssay ' take'
 

say blue;
call sysCurPos '11', '41'
call syssay 'you!'

 
say hblack;
call sysCurPos '15', '0'

SAY'       Please Maximize SCREEN SIZE  & Press Enter to Continue...'

 
say red;
call sysCurPos '14', '26'

CALL SYSPAUSE ObjectName
call SysCurState 'ON'


'cls'
echo on
'prompt $p$E[0;'34';'47';'5';'5'm]'
echo off
'cls'
return


InitVariables:
CharSet:
/* Foreground colors, not highlighted*/
black      ='[30m[1A'
red        ='[31m[1A'
green      ='[32m[1A'
yellow     ='[33m[1A'
blue       ='[34m[1A'
white      ='[37m[1A'
/* Foreground colors, highlighted*/
hblack      ='[1;30m[1A'
hred       ='[1;31m[1A'
hgreen     ='[1;32m[1A'
hyellow    ='[1;33m[1A'
hblue      ='[1;34m[1A'
hwhite     ='[1;37m[1A'

blue_o_white = '[34;47m[1A'
white_o_blue ='[37;44m[1A'
white_o_red  ='[37;41m[1A'
cursor_up  ='[1A'          /* Cursor up 1 line*/
cursor_up2 ='[2A'          /* Cursor up 2 lines */
cursor_down   ='[1B'       /* Cursor down 1 line */
cursor_right  ='[1C'       /* Cursor right 1 space  */
cr5 ='[9C'       /* Cursor right 5 spaces */
normal      ='[0m[1A'     /* Restore default attrib. and color    */
reverse     ='[7m[1A'     /* Reverse video   */

highlight   ='[1m[1A'     /* Highlight  */
invisible   ='[8m[1A'     /* Invisible */
return

SysPause:
parse arg prompt
  if prompt='' then
    prompt='Press Enter key when ready . . .'
  call SysSay prompt
  Pull .
  say
return
SysSay:
parse arg string
  call charout 'STDOUT', string
return

