#include "graph.h"

/*			UNICOST_GRAPH_

    The constructor passes the start node, goal node and number of
    operators to SEACH_.

*/

UNICOST_GRAPH_::UNICOST_GRAPH_(UNI_NODE_ *start, UNI_NODE_ *goal, int op)
    :SEARCH_(start, goal, op)
{
}



/*                  ADD

    This routine works much the same as BEST_::add(), except for the
    following. Since we don't use the heuristic estimate H nodes are
    ordered based on their G-value. Secondly, when a node is found
    to be already on CLOSED there's no need to check if the old node
    or the current node is better, since we are guaranteed to always
    find the cheapest node first (see Nilsson p.53).

*/

int UNICOST_GRAPH_::add(NODE_ *succ)
{
    UNI_NODE_
	*parent,
        *old = NULL,
        *bsucc = (UNI_NODE_ *) succ;

    int
        g;

    parent = (UNI_NODE_ *) bsucc->getparent();
    g = parent->get_g() + compute_g(*bsucc);
       /* a node's g-value is composed of the overall cost so far, i.e, the
          the cost of getting from the start node to the parent of this node
          and the added cost of getting from the parent to this node. */
    bsucc->set_g(g);

    if ((old = (UNI_NODE_ *) open.lookup(*succ)) != NULL)
    {					// node already on open
        if (bsucc->eval(*old) < 0)             // new node better
        {
            open.remove_found(DEALLOC);        // remove & destroy old node
            open.insert(*bsucc);
            return(1);
        }
        return(0);
    }
    if ((old = (UNI_NODE_ *) closed.lookup(*succ)) != NULL)
        return(0);   // no need for any further checks, see Nilsson 53!

// node neither on open nor on closed
    open.insert(*bsucc);
    return(1);
}
