#include "graph.h"

/*                      DEPTH_GRAPH_

    The constructor passes the start node, goal node and the number of
    operators to SEARCH_.

*/

DEPTH_GRAPH_::DEPTH_GRAPH_(NODE_ *start, NODE_ *goal, int op)
    :SEARCH_(start, goal, op)
{
}



/*                      ADD

    Adds a node to the search graph, only if it's not already in the
    graph.

*/

int DEPTH_GRAPH_::add(NODE_ *succ)
{
    if (!closed.lookup(*succ) && !open.lookup(*succ))
// if successors is neither on open nor closed add it to the HEAD of open
    {
        open.addtohead(*succ);
        return(1);
    }
    return(0);
}
