#include "nodes.h"

/*			NODE_

    The constructor initializes the node by setting all pointers to NULL.

*/

NODE_::NODE_()
{
    parent = NULL;
    next = NULL;
}



/*			EXPAND

    This function creates a linked list of NODE_'s by calling do_operator()
    and linking the nodes do_operator() returns together. We make expand()
    virtual because the user may want to implement his own version of
    expand().

*/

NODE_ *NODE_::expand(int op) const
{
    NODE_
	*start = NULL,		 // important, marks end of list
	*tmp;

    for (op--; op >= 0; op--)    // apply all of the operators one by one
    {
	tmp = do_operator(op);
	if (tmp == NULL)         // operator not applicable 
	    continue;

	tmp->setnext(start);     // builds a linked list
	start = tmp;
    }
    return(start);
}



/*			SETPARENT

    Sets parent of node.

*/

void NODE_::setparent(NODE_ *par)
{
    parent = par;
}



/*                      EVAL

    We don't make this function pure virtual because it's only needed in
    a best first and uniform cost search. Still, we must implement it
    because it is called in solve() for every node.

*/ 

int NODE_::eval(const SVOBJECT_ &) const
{
    return(1);
}



/*			GETPARENT

    Returns parent of node.

*/

NODE_ *NODE_::getparent() const
{
        return(parent);
}



/*			DO_OPER

    We can't make this function pure virtual because the user may
    implement either do_operator() or expand().

*/

NODE_ *NODE_::do_operator(int ) const
{
    puts("Wrong do_operator() function called!");
    return(NULL);
}



/*			GETNEXT

    Returns the next node in the list.

*/

NODE_ *NODE_::getnext() const
{
    return(next);
}



/*			SETNEXT

    Sets next field of node.

*/

void NODE_::setnext(NODE_ *node)
{
    next = node;
}
