#include "nodes.h"

/*                    AONODE_

    This constructor just initializes the node, it doesn't create
    room for any possible successors because at this point this
    information is still unknown.

*/

ANDNODE_::ANDNODE_()
    :AONODE_(AND)
{
    n_nodes = 0;
    succlist = NULL;	// succlist is an array of pointers to AONODE_'s
}



/*                      AONODE_

    The alternative constructor creates room for n-successors, i.e,
    it declares an array of n-pointers to AONODE_'s and updates
    n_nodes and n_left.

*/

ANDNODE_::ANDNODE_(int num)
    :AONODE_(AND, num)
{
   n_nodes = num;
   if (!(succlist = (AONODE_ **) malloc(num * sizeof(AONODE_ *))))
   {
	puts("Error: out of memory!");
	exit(0);
   }
}



/*			~ANDNODE_

    The destructor deallocates the array of node pointers.

*/

ANDNODE_::~ANDNODE_()
{
    delete [] succlist;   // but don't destroy the nodes themselves!
}



/*                       ADDSUCC

    Adds a node to the successor list of this node and increases
    n_nodes and n_left.

*/

void ANDNODE_::addsucc(AONODE_ *node)
{
    if (!(succlist = (AONODE_ **) realloc(succlist, (n_nodes + 1) *
					sizeof(AONODE_ *))))
    {
	puts("Error: out of memory");
	exit(0);
    }
    succlist[n_nodes] = node;
    n_nodes++;
    incn_left();
}


/*			SETSUCC

    Just like addsucc, this routine adds a node to the successor list of
    this node, except that it is assumed that memory has been allocated
    in the array for the node pointer.

*/

void ANDNODE_::setsucc(int index, AONODE_ *node)
{
    succlist[index] = node;
}



/*			GETN_NODES

    Returns the number of successors of this node.

*/

int ANDNODE_::getn_nodes() const
{
    return(n_nodes);
}



/*			GETSUCC

    Returns successor n of this node.

*/

AONODE_ *ANDNODE_::getsucc(int index) const
{
    return(succlist[index]);
}



/*                    DISPLAY

    This function should never be called since ANDNODE_ only has
    'administrative' value. Still, it needs to be implemented as
    display() is pure virtual in NODE_, from which ANDNODE_ is
    ultimately derived.

*/

void ANDNODE_::display() const
{
    puts("no display() function for class ANDNODE_");
}



/*		EQUAL

    Just like display equal() also needs to be implemented.

*/

int ANDNODE_::equal(const VOBJECT_ &) const
{
    return(0);
}
