#include "list.h"

LIST_::LIST_(int dstr)
{
    head = tail = found = NULL;
    nodecount = 0;
    deallocondestr = dstr;
}


LIST_::~LIST_()
{
    LIST_NODE_
        *p;

    LIST_NODE_::destroy = (deallocondestr == DEALLOC_ON_DESTRUCT) ? 
                          DEALLOC : NODEALLOC;

    while(head)
    {
	p = head;
        head = head->getnext();
        delete(p);
    }
}


VOBJECT_ *LIST_::gethead() const
{
    return(head->getdata());
}


VOBJECT_ *LIST_::gettail() const
{
    return(tail->getdata());
}


int LIST_::getcount() const
{
    return(nodecount);
}


int LIST_::getdestruct() const
{
    return(deallocondestr);
}


void LIST_::setdestruct(int dstr)
{
    deallocondestr = dstr;
}


void LIST_::addtohead(VOBJECT_ &obj)
{
    nodecount++;
    if (!head)
    {
        head = new LIST_NODE_(obj);
        tail = head;
    }
    else
    {
        head = new LIST_NODE_(obj, head, NULL);
        head->getnext()->setprev(head);
    }
}


void LIST_::addtotail(VOBJECT_ &obj)
{
    if (!tail)
        addtohead(obj);
    else
    {
	nodecount++;
        tail->setnext(new LIST_NODE_(obj, NULL, tail));
        tail = tail->getnext();
    }
}


VOBJECT_ *LIST_::lookup(VOBJECT_ &find)
{
    LIST_NODE_
        *p;

    for (p = head; p; p = p->getnext())
    {
        if (find.equal(*p->getdata()))
        {
            found = p;
            return(p->getdata());
        }
    }

    return(NULL);
}


void LIST_::remove_head(int dstr)
{
    remove_node(head, dstr);
}


void LIST_::remove_tail(int dstr)
{
    remove_node(tail, dstr);
}


void LIST_::remove_found(int dstr)
{
    remove_node(found, dstr);
}


void LIST_::remove_node(LIST_NODE_ *node, int dstr)
{
    if (!node)
	return;

    nodecount--;
    LIST_NODE_::destroy = dstr;

    if (node == found)
	found = NULL;

    if (node == head)
    {
	if ((head = head->getnext()) != NULL)
	    head->setprev(NULL);
	if (tail == node)
	    tail = head;
    }
    else if (node == tail)
    {
	tail = tail->getprev();
	tail->setnext(NULL);
    }
    else
    {
        node->getprev()->setnext(node->getnext());
        node->getnext()->setprev(node->getprev());
    }
   
    delete(node);
}


void LIST_::clear(int dstr)
{
    LIST_NODE_
        *p;

    LIST_NODE_::destroy = dstr;
                     
    while(head)
    {
	p = head;
        head = head->getnext();
        delete(p);
    }
    head = tail = found = NULL;
    nodecount = 0;
}

