#ifndef _tree_H_
#define _tree_H_

#include <stdio.h>
#include "nodes.h"
#include "search.h"
#include "bisearch.h"
#include "aosearch.h"

/*                 DEPTH_TREE_

    This class implements a depth first search algorithm, by generating
    a search TREE. It is derived from class SEARCH_.

*/

class DEPTH_TREE_ : public SEARCH_
{
    public:
        DEPTH_TREE_(NODE_ *, NODE_ *, int);
        int add(NODE_ *);
};



/*                  BREADTH_TREE_

    This class implements a breadth first search algorithm, by generating
    a search TREE. It is derived from class SEARCH_.

*/

class BREADTH_TREE_ : public SEARCH_
{
    public:
        BREADTH_TREE_(NODE_ *, NODE_ *, int);
        int add(NODE_ *);
};



/*               UNICOST_TREE_

    This class implements a uniform cost search algorithm, by generating
    a search TREE. It is derived from class SEARCH_ and processes nodes
    of class UNI_NODE_. Classes that are derived from class UNICOST_T_
    should have the following function:

    compute_g() : to compute the G-value of a node.

*/

class UNICOST_TREE_ : public SEARCH_
{
    public:
        UNICOST_TREE_(UNI_NODE_ *, UNI_NODE_ *, int);
        int add(NODE_ *);
        virtual int compute_g(const NODE_ &) = 0;
};




/*                    BIDEPTH_TREE_

    This class implements a bidirectional depth first search algorithm,
    by generating two search TREEs. It is derived from class BISEARCH_.

*/

class BIDEPTH_TREE_ : public BISEARCH_
{
    public:
        BIDEPTH_TREE_(NODE_ *, NODE_ *, int);
        int add(SORTEDLIST_ *, SORTEDLIST_ *, NODE_ *);
};



/*                   BIBREADTH_TREE_

    This class implements a bidirectional breadth first search algorithm,
    by generating two search TREEs. It is derived from class BISEARCH_.

*/

class BIBREADTH_TREE_ : public BISEARCH_
{
    public:
        BIBREADTH_TREE_(NODE_ *, NODE_ *, int);
        int add(SORTEDLIST_ *, SORTEDLIST_ *, NODE_ *);
};



/*                    AODEPTH_TREE_

    This class implements a depth first AND-OR search algorithm, by
    generating a AND-OR search TREE. It is derived from class AOSEARCH_.

*/

class AODEPTH_TREE_ : public AOSEARCH_
{
    public:
        AODEPTH_TREE_(AONODE_ *, int);
        void add(AONODE_ *);
};



/*                     AOBREADTH_TREE_

    This class implements a breadth first AND-OR search algorithm, by
    generating an AND-OR search TREE. It is derived from class AOSEARCH_.

*/

class AOBREADTH_TREE_ : public AOSEARCH_
{
    public:
        AOBREADTH_TREE_(AONODE_ *, int);
        void add(AONODE_ *);
};

#endif
