#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tree.h"


/*                     DEMO7

    In this demo we show how the AND/OR search algorithms can be used
    to implement a simple top-down parser.

*/



/*                     ITEM_, RULE_, LEX_

    First, we declare an enum ITEM_ to represent the syntactic categories.
    Next, we define a struct to represent DCG rules and a struct to represent
    words in the lexicon.

*/

enum ITEM_
{
    VOID,
    S,
    VP,
    IV,
    TV,
    SV,
    NP,
    SNP,
    N,
    DET,
    CN,
};

typedef struct RULE_
{
    int
        num;
    ITEM_
        head,
        *tail;
} RULE_;

typedef struct LEX_
{
    ITEM_
        head;
    char
        *tail;
} LEX_;



/*		       ELEMENT_

    Class element is a representation of the nodes generated during the
    search, it serves as an abstraction of the syntactic categories.
    Note that we implement expand() instead of do_operator() because
    there isn't a fixed number of operators for this problem (every DCG
    rule may rewrite a syntactic category to one or more new syntactic
    categories).

*/

class ELEMENT_ : public ORNODE_
{
    public:
        ELEMENT_(ITEM_);
        ITEM_ get_item() const;

// implementation of virtual functions
        int equal(const VOBJECT_ &) const;
        void display() const;
        NODE_ *expand(int) const;    // we use expand() instead of do_operator
    private:
        ITEM_
            item;	// syntactic category
};



/*			PARSE_

    Because we want to perform a depth-first search of and AND/OR tree
    we define a class PARSE_, derived from AODEPTH_TREE_. As a consequence
    we must implement function is_terminal().

*/

class PARSE_ : public AODEPTH_TREE_
{
    public:
        PARSE_(char **, ELEMENT_ *);
        int is_terminal(const AONODE_ &);
    private:
        char
            **string;       // text string to be passed
        int
            index;          // index to this string
};


