#include "demo4.h"

PUZZLE_::PUZZLE_(PNODE_ *start, PNODE_ *target)
    :BEST_(start, target, 4)
{
    goal = target;
}



PNODE_::PNODE_(const char *b, int empty_x, int empty_y)
{
    char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        *(p + i) = *(b + i);

    x = empty_x;
    y = empty_y;
}



PNODE_::PNODE_(const char *b, int old_x, int old_y, int new_x, int new_y)
{
    char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        *(p + i) = *(b + i);

    board[old_x][old_y] = board[new_x][new_y];
    board[new_x][new_y] = 0;

    x = new_x;
    y = new_y;
}



void PNODE_::display() const
{
    int
        row,
        col;

    for (row = 0; row < 3; row++)
    {
        for (col = 0; col < 3; col++)
            printf("%d ", board[row][col]);
        putchar('\n');
    }
    putchar('\n');
}



int PNODE_::equal(const VOBJECT_ &other) const
{
     if (x != ((const PNODE_ &)other).get_x()
          && y != ((const PNODE_ &)other).get_y())
            return(0);
    return(compare_board(((const PNODE_ &)other).get_board()));
}



const char (*PNODE_::get_board() const)[3]
{
    return(board);
}



int PNODE_::get_x() const
{
    return(x);
}



int PNODE_::get_y() const
{
    return(y);
}



int PNODE_::compare_board(const char bo[3][3]) const
{
    const char
        *p = *board,
        *b = *bo;

    int
        i;

    for (i = 0; i <= 8; i++)
        if (*(p + i) != *(b + i))
            return(0);

    return(1);
}



NODE_ *PNODE_::do_operator(int index) const
{
    switch(index)
    {
        case 0:
            return(do_left());
        case 1:
            return(do_right());
        case 2:
            return(do_up());
    }
    return(do_down());
}



PNODE_ *PNODE_::do_left() const
{
    if (!y)
        return(NULL);

    return(new PNODE_(*board, x, y, x, y - 1));
}



PNODE_ *PNODE_::do_right() const
{
    if (y == (2))
        return(NULL);

    return(new PNODE_(*board, x, y, x, y + 1));
}



PNODE_ *PNODE_::do_down() const
{
    if (x == (2))
        return(NULL);

    return(new PNODE_(*board, x, y, x + 1, y));
}



PNODE_ *PNODE_::do_up() const
{
    if (!x)
        return(NULL);

    return(new PNODE_(*board, x, y, x - 1, y));
}


/*                  COMPUT_G

    In this problem all arc costs are 1, so we don't have to do any
    computation in this function.

*/

int PUZZLE_::compute_g(const NODE_ &)
{
    return(1);
}



/*                     COMPUT_H

    This function returns the heuristic value associated with each
    node, by calling totdist(). 

*/

int PUZZLE_::compute_h(const NODE_ &node)
{
    return(totdist(((PNODE_ &)node).get_board(), goal->get_board()));
}



/*                  TOTDIST

    Computes the total or Manhatten distance of the tiles in the 
    current configuration from their 'home squares' (= the ordering
    of the tiles in the goal configuration). The Manhatten between
    two squares S1 and S2 is the distance between S1 and S2 in the
    horizontal direction plus the distance between S1 and S2 in the
    vertical direction.

*/

int PUZZLE_::totdist(const char now[3][3], const char target[3][3])
{
    int nrow, ncol,
        trow, tcol,
        found, tot = 0;

    for (nrow = 0; nrow < 3; nrow++)
        for (ncol = 0; ncol < 3; ncol++)
        {
            found = 0;
            if (now[nrow][ncol] == 0)       // skip empty tile!
                continue;
            for (trow = 0; trow < 3 && !found; trow++)
                for (tcol = 0; tcol < 3 && !found; tcol++)
                    if (now[nrow][ncol] == target[trow][tcol])
                    {
                        tot += abs(ncol - tcol) + abs(nrow - trow);
                        found = 1;
                    }
        }
    return(tot);
}



int main()
{
    char
        start[3][3] = {
                        {2, 1, 6},
                        {4, 0, 8},
                        {7, 5, 3},
                      };

    char
        goal[3][3] = {
                        {1, 2, 3},
                        {8, 0, 4},
                        {7, 6, 5},
                    };

    PUZZLE_
        puzzle(new PNODE_(*start, 1, 1), new PNODE_(*goal, 1, 1));

    puzzle.generate();
    return(1);
}
