#include "demo1.h"

/*                   PUZZLE_

    Passes the start node, goal node, and number of operators on
    the DEPTH_GRAPH_'s constructor.

*/

PUZZLE_::PUZZLE_(PNODE_ *start, PNODE_ *goal)
    :DEPTH_GRAPH_(start, goal, 4)
{
}



/*                    PNODE_

    Creates a new board configuration.

*/ 

PNODE_::PNODE_(OP_USED_ op_used, int empty_x, int empty_y)
{
    operator_used = op_used;
    x = empty_x;
    y = empty_y;
}



/*                       DISPLAY

    Displays the operator applied to get to this state and the
    coordinates of the empty tile of the current state.

*/ 

void PNODE_::display() const
{
    static char
        *move[] = { "start state",
                    "left",
                    "right",
                    "up",
                    "down"
                  };

    printf("%s - empty spot at: [%d] [%d]\n", move[operator_used], y, x);
}



/*                       EQUAL.CPP

    Determines if two states, i.e., two PNODE_'s are the same by
    comparing the set of coordinates of both objects.

*/

int PNODE_::equal(const VOBJECT_ &other) const
{
    return(x == ((const PNODE_ &)other).get_x()
          && y == ((const PNODE_ &)other).get_y());
}



/*                      GET_X.CPP

    Returns the x-coordinate of the position of the empty tile in
    the current configuration.

*/

int PNODE_::get_x() const
{
    return(x);
}



/*                       GET_Y.CPP

    Returns the y-coordinate of the position of the empty tile in
    the current configuration.

*/

int PNODE_::get_y() const
{
    return(y);
}



/*                    DO_OPER.CPP

    Returns a new PNODE_ object, i.e., a new state, by applying the
    appropriate operator to the current state, or NULL when the
    operator cannot be applied.

*/

NODE_ *PNODE_::do_operator(int index) const
{
    switch(index)
    {
        case 0:
            return(do_left());
        case 1:
            return(do_right());
        case 2:
            return(do_up());
    }
    return(do_down());
}



/*                   DO_LEFT

    Creates a new state/node representing the configuration that
    arises when the empty tile is moved left one position.
 
*/

PNODE_ *PNODE_::do_left() const
{
    if (!x)
        return(NULL);    // can't go left any further

    return(new PNODE_(left_used, x - 1, y));
}



/*                   DO_RIGHT

    Creates a new state/node representing the configuration that
    arises when the empty tile is moved right one position.

*/ 

PNODE_ *PNODE_::do_right() const
{
    if (x == (4 - 1))
        return(NULL);

    return(new PNODE_(right_used, x + 1, y));
}



/*                        DO_UP


    Creates a new state/node representing the configuration that
    arises when the empty tile is moved up one position.

*/

PNODE_ *PNODE_::do_up() const
{
    if (!y)
        return(NULL);       // can't go up any further
 
    return(new PNODE_(up_used, x, y - 1));
}



/*                    DO_DOWN

    Creates a new state/node representing the configuration that
    arises when the empty tile is moved down one position.

*/ 

PNODE_ *PNODE_::do_down() const
{
    if (y == (4 - 1))          // can't go down any further
        return(NULL);

    return(new PNODE_(down_used, x, y + 1));
}


int main()
{
    PUZZLE_
        puzzle(new PNODE_(none_used, 3, 3), new PNODE_(none_used, 0, 0));

    puzzle.generate();           // start search process

    return(1);
}
