#@ 1983,1993 EASEL CORPORATION. ALL RIGHTS RESERVED.
#UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT
#LAWS OF THE UNITED STATES. USE OF A COPYRIGHT NOTICE
#IS PRECAUTIONARY ONLY AND DOES NOT IMPLY
#PUBLICATION OR DISCLOSURE.

#THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION
#AND TRADE SECRETS OF EASEL CORPORATION. USE,
#DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT
#THE PRIOR EXPRESS WRITTEN PERMISSION OF EASEL CORPORATION.

#                RESTRICTED RIGHTS LEGEND
#Use, duplication, or disclosure by the Government is subject to
#restrictions as set forth in subparagraph (c) (ii) of the Rights in
#Technical Data and Computer Software clause at DFARS 252.227-7013
#or subparagraphs (c) (1) and (2) of Commercial Computer Software --
#Restricted Rights at 48 CFR 52.227-19, as applicable.

#                Easel Corporation
#        25 Corporate Drive, Burlington, MA 01803


#EASEL, EASEL/2, EASEL/Win, and EASEL Workbench are
#Registered Trademarks (R), and EASEL/DOS is a Trademark
#(TM), of Easel Corporation, Burlington, Massachusetts,
#U.S.A.


string CityName					# holds name of city during extraction
integer CityCounter is 1			# counts number of cities selected
boolean LoadedOK				# true indicates data was received

subroutine PackArray (string : DataLine, integer : Index ) is
#
# Used by subroutine LoadData to parse and put each line of data received into an
# array to be graphed. Depending on the type of graph, the array is loaded differently.
# The data is passed as a string in DataLine in the format: 
# 	"City name DD   DD   DD"  where DD is a one or 2 digit integer.
#
    if (item PieCH in MapGR is checked) then	# In the case of a pie chart
        extract from DataLine			# parse the line of data as follows;
            take 3 GLabels[Index]		# take the first 3 chars as the label
            skip to float			# skip to the next float in the string
            take word GDataY [Index,1]		# take the next three words and 
            take word GDataY [Index,2]		# copy them to the string array
            take word GDataY [Index,3]		# GDataY which is defined in BGraph
    else					# In the case of a bar graph
        extract from DataLine			# parse the line of data as follows;
            take 3 GLabels[Index]		# take the first 3 chars as the label
            skip to float			# skip to the next float in the string
            take word GDataY [1,Index]		# take the next three words and 
            take word GDataY [2,Index]		# copy them into GDataY. The indices
            take word GDataY [3,Index]		# for GDataY are [Sets, Elements].
    end if 					# All ifs have an end if.

action CreateGraph is
#
# Called by the response to item DisplayCH to generate the graph to display in the graph 
# reports window. The routine assume the graph data has been loaded into the graphing
# array GDataY. All of the variables in this routine which begin with a capitol 'G' are 
# defined in BGraph. By copying values to the predefined variable and then calling a 
# graphing routine (GBars or GPie) a graph is displayed with the desired features. Most 
# of the variables are optional or have defaults so that graphs can be easily created
#
    clear GraphGR				# clear any previous graph from the window
    copy 19 to GTitleColor			# set the graph title color 

    copy "* Estimated" to GFootnote		# set the text of the footnote
    copy 19 to GFootnoteColor			# set the color of the footnote
						# the position is determined by BGraph

    if (item PieCH in MapGR is checked) then	# in the case of a pie graph
        copy CityName to GTitle			# set the graph title to the city name
        copy true to GPieLabels			# turn labeling on for the pie chart
        copy "Male" to GLabels[1]		# load the label array with strings
        copy "Female" to GLabels[2]		# corresponding to the data sets
        copy "Unreg." to GLabels[3]

        copy 3 to GDataElements			# set the number of elements loaded
        copy 1 to GDataSets			# set the number of sets loaded
        copy "GraphGR" to GRegion		# name the region to draw the graph in
        action GPie				# call the action to draw a pie graph
    else
        # Bar graph
        copy "Registered Voters 1990 *" to GTitle
        copy "Male" to GLegend[1]
        copy "Female" to GLegend[2]
        copy "Unreg." to GLegend[3]
        copy true to GLegendOn
        copy 19 to GLegendColor
        copy false to GPieLabels
        copy "Percentage" to GyTitle		# bar graphs have optional axis titles
        copy 19 to GyTitleColor			# with custom color

        copy 3 to GDataSets			# set the number of data sets 
        copy (CityCounter - 1) to GDataElements # and elements to be graphed
        copy 1 to CityCounter			# reset the city counter
        copy true to Graph3D			# turn on the three dimensional bars option
        copy "GraphGR" to GRegion		# name the region to draw the graph in
        action GBars				# call the BGraph action to draw the graph
    end if 

subroutine LoadData ( boolean: LoadStatus ) is 
# 
# Used in the response to item DisplayCH to load the data into the text report window
# for display and graphing. The data is loaded asynchronously from a data file called 
# voting.dat using a local application (a 'C' program called votedata.exe) to search the 
# file and send lines of voting data which match the search criteria. This is one example 
# of how Easel programs can communicate with other applications. 
#
    string VoteData				# local subroutine variables
		FileName is "voting.dat"
                         
    copy 1 to CityCounter			# initialize the counter
    clear DataTR				# clear the report window
    copy true to LoadStatus			
    for each member of SelectedCities loop	# loop thru the members of the class
        copy parameter of member to CityName	# parameter is the city name
        # send an asynchronous request to the local application for information
        send "find '" CityName "' in " FileName "\n" to DataFeed
        begin guarded WaitForAnswer		# the next responses wait for events
            response to line "done" from DataFeed
                leave block			# leave the block after each line is added
            response to line "ERROR" from DataFeed
                copy false to LoadStatus	# the local is not working correctly
                leave block			# give up
            response to line from DataFeed
                copy input to VoteData		# input hold the information requested
                add to DataTR insert VoteData "\n"
                call PackArray (VoteData, CityCounter)
                copy (CityCounter + 1) to CityCounter
        end WaitForAnswer
    end loop					# go on to the next selected city
