/****************************************************************************
		Copyright (C) 1990-1994 Easel Corporation
		All Rights Reserved.

		NOTICE - PROPRIETARY AND CONFIDENTIAL
  This computer program is and contains trade secret and confidential
  and proprietary information of Easel Corporation.  All use, disclosure,
  and/or reproduction not specifically authorized in writing by Easel
  Corporation is prohibited.  This program may also be protected under
  the copyright and trade secrets laws of countries other than the U.S.A.

		RESTRICTED RIGHTS LEGEND
  Use, duplication, or disclosure by the Government is subject to
  restrictions as set forth in subparagraph (c) (ii) of the Rights in
  Technical Data and Computer Software clause at DFARS 252.227-7013
  or subparagraphs (c) (1) and (2) of Commercial Computer Software --
  Restricted Rights at 48 CFR 52.227-19, as applicable.

  Easel Corporation, 25 Corporate Drive, Burlington, MA 01803, U.S.A.


  EASEL, EASEL/2, EASEL/Win, and EASEL Workbench are Registered
  Trademarks (R); EASEL Renovator Plus, Enterprise Workbench, EASEL/DOS,
  EASEL/32 and DB/Assist are Trademarks (TM), of Easel Corporation,
  Burlington, Massachusetts.
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************
 *								      *
 * Name: ESLLIB.H for Easel/32					      *
 *								      *
 * Declarations for dynamic-link library support routines.	      *
 *								      *
 **********************************************************************/

#ifndef HSTRING_DEF
#define HSTRING_DEF
typedef unsigned long HSTRING;
typedef HSTRING *PHSTRING;
#endif	/* HSTRING_DEF */

/*************************************************************************
**									**
**	These definitions, macros and prototypes comprise the magic	**
**	that allow this header file to be used with IBM CSet/2 when	**
**	compiling 32 bit DLL's or Microsoft C 6.0 when compiling 16	**
**	bit DLL's and have the entry points appear the same.		**
**									**
**	If you are not using one of these compilers, you must define	**
**	either EDLL_ENTRY_32 when using a 32 bit compiler or define	**
**	EDLL_ENTRY_16 when using a 16 bit compiler.			**
**									**
**	EDLL_ENTRY_16 defines the functions as they are used in the	**
**	previous versions of EASEL/2 and as the function references	**
**	appear in the source.						**
**									**
**	EDLL_ENTRY_32 defines the special names that are used for	**
**	the entry points in EASEL/2 3.0 for OS/2 2.0.			**
**									**
*************************************************************************/

#if (!defined(EDLL_ENTRY_32) && !defined(EDLL_ENTRY_16))
  #if ((defined(__IBMC__) || defined(__IBMCPP__)) && defined(__32BIT__))
    /* We're compiling with the IBM CSet/2 32 bit compiler */
    #define EDLL_ENTRY_32
  #elif (defined(_MSC_VER))
    /* We're compiling with the Microsoft C compiler */
    #define EDLL_ENTRY_16
  #endif
#endif
#if (!defined(EDLL_ENTRY_32) && !defined(EDLL_ENTRY_16))
#error Must define either EDLL_ENTRY_32 or EDLL_ENTRY_16.  See ESLLIB.H
#endif

#if defined(EDLL_ENTRY_32)
/* These macros turn the standard names to 32 bit entry points		*/
#define EslCreateString(p1, p2)		EslCreateString32(p1, p2)
#define EslQueryProgramID()		EslQueryProgramID32()
#define EslQueryStringAddr(p1)		EslQueryStringAddr32(p1)
#define EslQueryStringChars(p1, p2, p3)	EslQueryStringChars32(p1, p2, p3)
#define EslSetStringHandle(p1, p2)	EslSetStringHandle32(p1, p2)
#define EslSetStringValue(p1, p2, p3)	EslSetStringValue32(p1, p2, p3)
#endif /* EDLL_ENTRY_32 */

/* EASEL Public API functions */

/* The following functions have their prototypes	*/
/* defined explicitly for 16 and 32 bit.		*/
#if defined(EDLL_ENTRY_32)
HSTRING EXPENTRY EslCreateString32(ULONG, PCHAR);
LONG	EXPENTRY EslQueryProgramID32(void);
PSZ	EXPENTRY EslQueryStringAddr32(HSTRING);
ULONG	EXPENTRY EslQueryStringChars32(HSTRING, PCHAR, ULONG);
BOOL	EXPENTRY EslSetStringHandle32(PHSTRING,HSTRING);
HSTRING EXPENTRY EslSetStringValue32(PHSTRING,PCHAR,ULONG);

#elif defined(EDLL_ENTRY_16)
HSTRING EXPENTRY EslCreateString(USHORT, PCHAR);
LONG	EXPENTRY EslQueryProgramID(void);
PSZ	EXPENTRY EslQueryStringAddr(HSTRING);
USHORT	EXPENTRY EslQueryStringChars(HSTRING, PCHAR, USHORT);
BOOL	EXPENTRY EslSetStringHandle(PHSTRING,HSTRING);
HSTRING EXPENTRY EslSetStringValue(PHSTRING,PCHAR,USHORT);

#endif /* EDLL_ENTRY_32 or EDLL_ENTRY_16 */


/* The following EASEL Public API functions are callable from within
 * EASEL applications (see esllib.inc), and are also callable from DLL's.
 */
HSTRING EXPENTRY EslCsvQuote(HSTRING);
HSTRING EXPENTRY EslCsvUnQuote(HSTRING);
HSTRING EXPENTRY EslParseColumn(PHSTRING, LONG *, HSTRING, HSTRING);
HSTRING EXPENTRY EslParseRow(PHSTRING, HSTRING, HSTRING);
LONG EXPENTRY EslNumRows(HSTRING, HSTRING, HSTRING);
LONG EXPENTRY EslNumColumns(HSTRING, HSTRING, HSTRING);

/* External string support functions */
HSTRING EXPENTRY EslXstr(LONG xid, HSTRING NotFound);
HSTRING EXPENTRY EslXstrFromDLL(LONG xid, HSTRING DLLName, HSTRING NotFound);

/* External string support subroutines */
LONG EXPENTRY EslXstrSetPrimaryDLL(HSTRING *pDLLName);
LONG EXPENTRY EslXstrSetSecondaryDLL(HSTRING *pDLLName);
LONG EXPENTRY EslXstrResetAllStrings(LONG *fVariablesToo);
LONG EXPENTRY EslXstrPreloadAllStrings(void);

#ifdef __cplusplus
}
#endif

