/*-----------------------------------------------------------------------------
    file:   demo.c
    desc:   Boyer-Moore text search algorithm demo (Windows version)
    by:     Patrick Ko
    date:   6 Mar 91 - born
    revi:   4 Apr 94 - port Windows 3.1
    note:   use huge pointers to cater for big contiguous memory
-----------------------------------------------------------------------------*/
#include <windows.h>
#include <windowsx.h>
#include <memory.h>
#include "demo.h"
#include "boyer.h"

long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;

static char szAppName [] = "Demo" ;
static char temp[128];

static LPSTR ss = NULL;
static LPSTR sf = NULL;
static LPSTR sb = NULL;
static int msg = 0;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    HWND hwnd;
    MSG msg;
    WNDCLASS wndclass;

    if (!hPrevInstance)
    {
        wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
        wndclass.lpfnWndProc   = WndProc ;
        wndclass.cbClsExtra    = 0 ;
        wndclass.cbWndExtra    = 0 ;
        wndclass.hInstance     = hInstance ;
        wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
        wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
        wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
        wndclass.lpszMenuName  = szAppName ;
        wndclass.lpszClassName = szAppName ;

        RegisterClass (&wndclass) ;
    }

    hwnd = CreateWindow (szAppName, "Boyer-Moore Algorithm Demonstration",
           WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
           CW_USEDEFAULT, NULL, NULL, hInstance, NULL) ;

    ShowWindow (hwnd, nCmdShow) ;
    UpdateWindow (hwnd) ;

    while (GetMessage (&msg, NULL, 0, 0))
    {
        TranslateMessage (&msg) ;
        DispatchMessage (&msg) ;
    }
    return msg.wParam ;
}

long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
    HMENU hMenu;
    static short cxChar, cxCaps, cyChar;
    HDC hdc;
    PAINTSTRUCT ps;
    TEXTMETRIC tm;
    long i;

    switch (message)
    {
        case WM_CREATE:
            hdc = GetDC(hwnd);
            GetTextMetrics(hdc, &tm);
            cxChar = tm.tmAveCharWidth;
            cxCaps = (tm.tmPitchAndFamily & 1 ? 3 : 2) * cxChar / 2;
            cyChar = tm.tmHeight + tm.tmExternalLeading;
            ReleaseDC(hwnd, hdc);
            return 0;

        case WM_COMMAND:
            hMenu = GetMenu (hwnd) ;
            switch (wParam)
            {
                case IDM_GO:

                    msg = 1;
                    InvalidateRect(hwnd, NULL, FALSE);
                    SendMessage(hwnd, WM_PAINT, 0, 0L);

                    /* allocate around 1M space */
                    ss = (char huge *)GlobalAllocPtr(GMEM_MOVEABLE, 1000000L);

                    /* initialize the space will texts */
                    for (i=0; i<1000000L; i+=4)
                    {
                        memcpy( (HPSTR)ss + i, "wild", 4 );
                    }

                    /* put our target "tiger" at position ss + 9999995L */
                    memcpy( (HPSTR)ss + 999995L, "tiger", 5);

                    msg++;
                    InvalidateRect(hwnd, NULL, FALSE);
                    SendMessage(hwnd, WM_PAINT, 0, 0L);

                    /* setup what you want to search */
                    SetFindPattern( "tiger" );

                    /* search string in forward manner */
                    sf = Find(ss, 1000000L);

                    /* search string in backward manner */
                    /* be careful not to specify a "huge pointer" outside */
                    /* what you have allocated in Windows, since Windows */
                    /* huge library does some work to translate your ptr */
                    /* into the GlobalAlloc() space */
                    sb = FindBackward((HPSTR)ss + 999999L, 1000000L);

                    GlobalFreePtr(ss);

                    msg++;
                    InvalidateRect(hwnd, NULL, FALSE);
                    SendMessage(hwnd, WM_PAINT, 0, 0L);

                    return 0 ;

                case IDM_EXIT:
                    SendMessage (hwnd, WM_CLOSE, 0, 0L) ;
                    return 0 ;

                case IDM_ABOUT:
                    MessageBox (hwnd, "Boyer-Moore Algorithm Demo",
                             szAppName, MB_ICONINFORMATION | MB_OK) ;
                    return 0 ;
            }
            break ;

        case WM_PAINT:
            switch (msg)
            {
                case 1:
                    hdc = BeginPaint(hwnd, &ps);
                    wsprintf(temp, "initializing search space");
                    TextOut(hdc, cxChar, cyChar * 1, temp, lstrlen(temp));
                    EndPaint(hwnd, &ps);
                    break;

                case 2:
                    hdc = BeginPaint(hwnd, &ps);
                    wsprintf(temp, "begin search:");
                    TextOut(hdc, cxChar, cyChar * 2, temp, lstrlen(temp));
                    wsprintf(temp, "search for word \"tiger\" in 1M space:");
                    TextOut(hdc, cxChar, cyChar * 3, temp, lstrlen(temp));
                    EndPaint(hwnd, &ps);
                    break;


                case 3:
                    if (ss == NULL) break;
                    hdc = BeginPaint(hwnd, &ps);
                    wsprintf(temp, "Find() pattern found at offset = %lu", (DWORD)((HPSTR)sf - (HPSTR)ss));
                    TextOut(hdc, cxChar, cyChar * 4, temp, lstrlen(temp));

                    wsprintf(temp, "FindBackward() pattern found at offset = %lu", (DWORD)((HPSTR)((HPSTR)ss + 999999L) - (HPSTR)sb));
                    TextOut(hdc, cxChar, cyChar * 5, temp, lstrlen(temp));
                    EndPaint(hwnd, &ps);
                    break;

                default:
                    break;
            }
            break;

        case WM_DESTROY :
            PostQuitMessage (0) ;
            return 0 ;
    }
    return DefWindowProc (hwnd, message, wParam, lParam) ;
}
/*
main()
{
}
  */
