ECHO OFF
REM ***************************************
REM *                                     *
REM *  MBSETUP.BAT  -  Mace Backup Setup  *
REM *                                     *
REM *  Usage: a:mbsetup a: c: \mace       *
REM *                                     *
REM ***************************************
REM
REM  Verify all the parameters exist.
REM
if %1$==$ goto usage
if %2$==$ goto usage
if %3$==$ goto usage
REM
REM  Verify the directory we are to create does not exist.
REM
if  exist %2%3\*.*            goto direxists
REM
REM  Verify hard disk letter is for a valid hard disk.
REM
if  not exist %2\*.*          goto hardwrong
REM
REM  Verify user gave us the right floppy disk letter.
REM
if  not exist %1\mbsetup.bat  goto fddwrong
cd %1\
REM
REM  Verify all the files are on the release disk.
REM
if  not exist %1mb.exe        goto diskerr
if  not exist %1mr.exe        goto diskerr
if  not exist %1mv.exe        goto diskerr
if  not exist %1readme        goto diskerr
REM
REM  Ok, everything seems to be correct, talk to the user.
REM
echo *
echo **************************************************
echo *                                                *
echo *   Mace Backup (tm) - Version 2.00              *
echo *   Copyright Paul Mace Software, Inc. 1988.     *
echo *   Copyright Phoenix Research, Inc. 1987-1988.  *
echo *   All rights reserved.                         *
echo *                                                *
echo **************************************************
echo *
REM
REM  Create the directory.
REM
md %2%3
REM
REM  Copy MB, MR, MV into that directory.
REM
copy %1*.exe %2%3  > NUL:
REM
REM  Copy all of the command files into that directory.
REM  And then copy the README file.
REM
copy %1*.m?   %2%3 > NUL:
copy %1readme %2%3 > NUL:
REM
REM  Now, tell the user all files are installed.
REM
echo *
echo **********************************
echo *                                *
echo *  Mace Backup is now installed  *
echo *                                *
echo **********************************
goto end

:direxists
echo off
echo The directory that you specified for Mace Backup files already exists.
echo The directory must not exist prior to running MBSETUP.  You may use
echo another directory or remove this one (rd %3).
goto :usage

:hardwrong
echo off
echo You have specified an invalid hard disk letter (%2).  Run MBSETUP
echo again with the correct letter specified.
goto :usage

:fddwrong
echo off
echo The letter you specified for the floppy disk drive which contains the
echo Mace Backup release disk is not a correct disk drive letter.
goto :usage

:filemiss
echo off
echo One or more files are missing from the Mace Backup release disk.
echo Consult your manual for the names of all of the files that are
echo required.
goto :usage

:usage
echo off
echo Example Usage: A:MBSETUP A: C: \MACE
echo                A:    - floppy disk where release disk is located.
echo                C:    - hard disk to install Mace Backup on
echo                \MACE - directory on C: to use for Mace Backup
:end
