// demodlg.cpp : implementation file
// 

#include <windows.h>

#include "stdafx.h"
#include "ipwvc.h"
#include "demodlg.h"
#include "ipc.h"			//the include file for Auto-Pro functions

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


BOOL	pause = TRUE;       /*whether to pause between operations*/

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg dialog

CDemoDlg::CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDemoDlg)
	ON_BN_CLICKED(IDC_DEMOBUTTON1, OnClickedDemobutton1)
	ON_BN_CLICKED(IDC_DEMOBUTTON2, OnClickedDemobutton2)
	ON_BN_CLICKED(IDC_DEMOBUTTON3, OnClickedDemobutton3)
	ON_BN_CLICKED(IDC_PAUSECHECK, OnClickedPausecheck)
	ON_BN_CLICKED(IDD_DEMOBUTTON4, OnClickedDemobutton4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg message handlers

void CDemoDlg::OnClickedDemobutton1()
{
    //Video enhancement demo 
	//If user select to pause between steps, a message box comes up indicating what's next
	if(pause) MessageBox((LPCSTR)"Load the Image.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpWsLoad("c:\\ipwin\\images\\bankvid.tif", "TIF");		//used '\\' to avoid '\i', load an image
	if(pause) MessageBox((LPCSTR)"Histogram equilization.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpHstEqualize(EQ_EXPONENTIAL);							//do a histogram equilization
	if(pause) MessageBox((LPCSTR)"Apply LUT.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpLutApply();											//apply LUT
	if(pause) MessageBox((LPCSTR)"Sharpen the image.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFltSharpen(3, 10, 2);									//Sharpen the image
	if(pause) MessageBox((LPCSTR)"Resize the image.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpWsScale(753, 462, 1);									//resize the image
	
}

void CDemoDlg::OnClickedDemobutton2()
{   
	RECT	frame;
	
	//FFT demo codes
	//If user select to pause between steps, a message box comes up indicating what's next
	if(pause) MessageBox((LPCSTR)"Load the Image.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpWsLoad("c:\\ipwin\\images\\noise.tif", "TIF");		//load an image
	if(pause) MessageBox((LPCSTR)"Forward FFT.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFftForward(FFT_SPECTRUM, 0);							//forward FFT
	IpDocMove(372, 206);									//move the spectrum window
	if(pause) MessageBox((LPCSTR)"Create an AOI box.", (LPCSTR)"Image-Pro Application", MB_OK);
	frame.left = 86;
	frame.right = 96;
	frame.top = 137;
	frame.bottom = 168;
	IpAoiCreateBox((LPRECT) &frame);    					//create an AOI box in the spectrum window
	if(pause) MessageBox((LPCSTR)"Do a spike cut.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFftSpikeCut(FFT_NOTCH, 50, 1);						//do a spike cut on the spectrum
	if(pause) MessageBox((LPCSTR)"Create an elliptical AOI.", (LPCSTR)"Image-Pro Application", MB_OK);
	frame.left = 97;
	frame.right = 116;
	frame.top = 108;
	frame.bottom = 123;
	IpAoiCreateEllipse((LPRECT) &frame);					//create an elliptical AOI
	if(pause) MessageBox((LPCSTR)"Spike cut.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFftSpikeCut(FFT_NOTCH, 50, 1);						//spike cut with the elliptical AOI
	if(pause) MessageBox((LPCSTR)"Inverse FFT.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFftInverse(FFT_SOURCE, 1);					//do an inverse FFT, showing noise removed from the image.
	
}

void CDemoDlg::OnClickedDemobutton3()
{
	//Image enhancement demo
	//If user select to pause between steps, a message box comes up indicating what's next
	if(pause) MessageBox((LPCSTR)"Load the image.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpWsLoad("c:\\ipwin\\images\\fprint.tif", "TIF");	//load an image
	if(pause) MessageBox((LPCSTR)"Flatten the background.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFltFlatten(0, 20);								//flatten it's background
	if(pause) MessageBox((LPCSTR)"Hi pass filtering.", (LPCSTR)"Image-Pro Application", MB_OK);
	IpFltHiPass(3, 10, 1);								//do a hi pass filtering
	
}

void CDemoDlg::OnClickedPausecheck()
{
	//if the check box was clicked on, toggle the global variable.
	pause = !pause;
		
}


void CDemoDlg::OnClickedDemobutton4()
{   
	//Demo for using common dialog under MFC
	//First, initialize a CFileDialog object.
	CFileDialog fileDlg(TRUE, NULL, NULL, OFN_CREATEPROMPT, 
		" GIF files(*.gif) | *.gif | JPEG files(*.jpg) | *.jpg | TIFF files(*.tif) | *.tif ||",NULL);
	
	if(fileDlg.DoModal() == IDOK)  //bring up the file open dialog box
	{                              //if a valid file is selected...
		CString	pathName = fileDlg.GetPathName();       //get the path and file name
		CString fileExt = fileDlg.GetFileExt();         //get the file extension
	
		LPSTR	szPathName = (LPSTR) (pathName.operator const char*());     //convert the file name and extension from the CString objects
		LPSTR	szFileExt = (LPSTR) (fileExt.operator const char*());
		IpWsLoad(szPathName, szFileExt);                	//load the image file in Image-Pro
	}
	
}

