'------------------------------------------------------------------
' Windows definition
'------------------------------------------------------------------
Type RECT
	left As Integer
	top As Integer
	right As Integer
	Bottom As Integer
End Type

Type POINTAPI
	x As Integer
	y As Integer
End Type

'------------------------------------------------------------------
' HIL definitions
'------------------------------------------------------------------

Type TRACK
    TrackProc As Long
    Caption As Long
End Type

Global Const IMC_BILEVEL = 0
Global Const IMC_GRAY = 1
Global Const IMC_PALETTE = 2
Global Const IMC_RGB = 3
Global Const IMC_GRAY12 = 4
Global Const IMC_FLOAT = 5

Global Const OR_LEFTRIGHT = 1
Global Const OR_UPDOWN = 2
Global Const OR_TRANSPOSE = 3
Global Const OR_ROTATE90 = 4
Global Const OR_ROTATE270 = 5
Global Const OR_ROTATE180 = 6

Global Const RA_TOPLEFT = 1
Global Const RA_TOP = 2
Global Const RA_TOPRIGHT = 3
Global Const RA_LEFT = 4
Global Const RA_CENTER = 5
Global Const RA_RIGHT = 6
Global Const RA_BOTTOMLEFT = 7
Global Const RA_BOTTOM = 8
Global Const RA_BOTTOMRIGHT = 9

Global Const EQ_BESTFIT = 0
Global Const EQ_LINEAR = 1
Global Const EQ_BELL = 2
Global Const EQ_LOGARITHMIC = 3
Global Const EQ_EXPONENTIAL = 4

Global Const IFFCOMP_NONE = 0
Global Const IFFCOMP_DEFAULT = 1
Global Const IFFCOMP_RLE = 2
Global Const IFFCOMP_CCITT1D = 3
Global Const IFFCOMP_CCITTG3 = 4
Global Const IFFCOMP_CCITTG4 = 5
Global Const IFFCOMP_LZW = 6
Global Const IFFCOMP_LZWHPRED = 7
Global Const IFFCOMP_JPEG = 8
	      
Global Const IFFCL_BILEVEL = 0
Global Const IFFCL_GRAY = 1
Global Const IFFCL_PALETTE = 2
Global Const IFFCL_RGB = 3
Global Const IFFCL_RGBPLANAR = 4
Global Const IFFCL_RGBA = 5
Global Const IFFCL_RGBAPLANAR = 6

'------------------------------------------------------------------
' HAIL definitions
'------------------------------------------------------------------
Global Const CM_RGB = 0
Global Const CM_HSI = 1
Global Const CM_HSV = 2
Global Const CM_YIQ = 3

Global Const BLBM_AREA = 0
Global Const BLBM_ASPECT = 1
Global Const BLBM_BOX_AREA = 2
Global Const BLBM_BOX_XY = 3
Global Const BLBM_CENTRX = 4
Global Const BLBM_CENTRY = 5
Global Const BLBM_DENSITY = 6
Global Const BLBM_DIRECTION = 7
Global Const BLBM_HOLEAREA = 8
Global Const BLBM_HOLEAREARATIO = 9
Global Const BLBM_MAJORAX = 10
Global Const BLBM_MINORAX = 11
Global Const BLBM_MAXFERRET = 12
Global Const BLBM_MINFERRET = 13
Global Const BLBM_MEANFERRET = 14
Global Const BLBM_MAXRADIUS = 15
Global Const BLBM_MINRADIUS = 16
Global Const BLBM_NUMHOLES = 17
Global Const BLBM_PERIMETER = 18
Global Const BLBM_RADIUSRATIO = 19
Global Const BLBM_ROUNDNESS = 20
Global Const BLBM_CLUSTER = 21
Global Const BLBM_RED = 22
Global Const BLBM_GREEN = 23
Global Const BLBM_BLUE = 24
Global Const BLBM_PERAREA = 25

Global Const OPA_ADD = 0
Global Const OPA_SUB = 1
Global Const OPA_DIFF = 2
Global Const OPA_MULT = 3
Global Const OPA_DIV = 4
Global Const OPA_AVG = 5
Global Const OPA_MAX = 6
Global Const OPA_MIN = 7

Global Const OPL_AND = 0
Global Const OPL_OR = 1
Global Const OPL_XOR = 2
Global Const OPL_NAND = 3
Global Const OPL_NOR = 4
Global Const OPL_NOT = 5
Global Const OPL_COPY = 6

Global Const MORPHO_2x2SQUARE = 0
Global Const MORPHO_3x1ROW = 1
Global Const MORPHO_1x3COLUMN = 2
Global Const MORPHO_3x3CROSS = 3
Global Const MORPHO_5x5OCTAGON = 4
Global Const MORPHO_CUSTOM = 5

Global Const FFT_NOTCH = &H0
Global Const FFT_PHASE = &H1
Global Const FFT_SPECTRUM = &H2
Global Const FFT_HANNING = &H1000

Global Const MORPHO_7x7OCTAGON = 6
Global Const MORPHO_11x11OCTAGON = 7

Global Const FFT_SOURCE = -1
Global Const FFT_NEWIMAGE = -2

'------------------------------------------------------------------
' IPWIN definitions
'------------------------------------------------------------------
Global Const COLORMODEL = 100
Global Const AUTOUPDATE = 102
Global Const SCAL = 103
Global Const ICAL = 104
Global Const ACCUMULATE = 105
Global Const LINETYPE = 106
Global Const BIN = 107
Global Const BRIGHTNESS = 108
Global Const CONTRAST = 109
Global Const GAMMA = 110
Global Const STATISTICS = 111
Global Const ORIGIN = 112
Global Const GRID = 113
Global Const REFERENCE = 114
Global Const FREEZE = 115
Global Const CURVE = 116
Global Const UNIT = 117
Global Const Channel = 118
Global Const CHANNEL1 = 120
Global Const CHANNEL2 = 121
Global Const CHANNEL3 = 122

Global Const BLOB_OUTLINEMODE = 0
Global Const BLOB_OUTLINECOLOR = 1
Global Const BLOB_LABELMODE = 2
Global Const BLOB_LABELCOLOR = 3
Global Const BLOB_SMOOTHING = 4
Global Const BLOB_MINAREA = 5
Global Const BLOB_FILLHOLES = 6
Global Const BLOB_BRIGHTOBJ = 8
Global Const BLOB_AUTORANGE = 9
Global Const BLOB_MEASUREOBJECTS = 10
Global Const BLOB_FILTEROBJECTS = 11
Global Const BLOB_ADDCOUNT = 12
Global Const BLOB_CLEANBORDER = 13

Global Const CM = 0
Global Const INCHES = 1
Global Const PIXELS = 2

Global Const SEG_SELNEW = 0
Global Const SEG_SELADD = 1
Global Const SEG_SELSUBTRACT = 2

Global Const MASK_BILEVELNEW = 0
Global Const MASK_FOREGROUND = 1
Global Const MASK_BACKGROUND = 2
Global Const MASK_BILEVELINPLACE = 3

Global Const FILLCOLOR = 0
Global Const FILLHUE = 1
Global Const FILLTINT = 2
Global Const FILLPATTERN = 3
Global Const FILLTEXTURE = 4

Global Const CLRFORE = 0
Global Const CLRBACK = 1
Global Const CLRWHITE = 2
Global Const CLRBLACK = 3

Global Const FRAME_NONE = 0
Global Const FRAME_RECTANGLE = 1
Global Const FRAME_ELLIPSE = 2
Global Const FRAME_IRREGULAR = 3

Global Const THICKNORMAL = 0
Global Const THICKHORZ = 1
Global Const THICKVERT = 2
Global Const THICKAVG = 3
Global Const THICKSTDDEV = 4

Global Const INF_TITLE = 0
Global Const INF_ARTIST = 1
Global Const INF_DATE = 2
Global Const INF_DESCRIPTION = 3
Global Const INF_DPIX = 4
Global Const INF_DPIY = 5

Global Const LUT_BRIGHTNESS = 0
Global Const LUT_CONTRAST = 1
Global Const LUT_GAMMA = 2
Global Const LUT_HISHAD = 3
Global Const LUT_4TONES = 4
Global Const LUT_8TONES = 5
Global Const LUT_FREEFORM = 6
Global Const LUT_ALL = 7

Global Const MEAS_STATS = 0
Global Const MEAS_DISPCOLOR = 1
Global Const MEAS_LABELCOLOR = 2
Global Const MEAS_THICKMODE = 3
Global Const MEAS_LENGTH = 4
Global Const MEAS_AREA = 5
Global Const MEAS_ANGLE = 6
Global Const MEAS_TRACE = 7
Global Const MEAS_THICK = 8
Global Const MEAS_TAG = -2
Global Const MEAS_ALL = -1

Global Const AOIDELETE = 0
Global Const AOIADD = 1
Global Const AOISET = 2
Global Const AOISHOWDLG = 3
Global Const AOIHIDEDLG = 4
Global Const AOILOAD = 5
Global Const AOISAVE = 6

Global Const DOCSEL_NEXTID = -1
Global Const DOCSEL_PREVID = -2
Global Const DOCSEL_ACTIVE = -3

Global Const DOCS_CASCADE = 0
Global Const DOCS_TILE = 1
Global Const DOCS_OVERLAP = 2

Global Const ACQ_NEW = -1
Global Const ACQ_CURRENT = -2

Global Const RUN_NORMAL = 5
Global Const RUN_MINIMIZED = 2
Global Const RUN_MAXIMIZED = 3

Global Const RUN_AUTOCLOSE = 1
Global Const RUN_MODAL = 2

Global Const S_APPEND = 1
Global Const S_STATS = 2
Global Const S_DATA = 4
Global Const S_RANGE = 8
Global Const S_CLIPBOARD = 16
Global Const S_HEADER = 256
Global Const S_LEGEND = 512
Global Const S_X_AXIS = 1024

Global Const MENU_ID = 1
Global Const MENU_NAME = 2
Global Const MENU_COORD = 4
Global Const MENU_DLL = 8

Global Const LOAD_PROMPT = -1
Global Const LOAD_SMALLEST = -3

Global Const PRT_ACTUAL = 1
Global Const RT_FIT = 2
Global Const PRT_DISTORT = 3

'------------------------------------------------------------------
' Global Variables
'------------------------------------------------------------------
Dim ipRect As RECT
Dim Pts(2048) As POINTAPI
Dim Lut(256) As Integer
Dim ipBins(16) As Single
Dim ipClassifiers(3) As Integer
Dim ipICal(512) As Single
Dim ipHalfTypes(7) As Integer
Dim ipHalfScreens(7) As Integer
Dim ret As Integer


Declare Function IpEscape Lib "IPC" (ByVal LibName As String, ByVal LoadMode As Integer, ByVal sParam As Integer, ByVal szParam As String) As Integer

'------------------------------------------------------------------
' Video acquisition
'------------------------------------------------------------------
Declare Function IpAcqAverage Lib "IPC" (ByVal Frames As Integer, ByVal Divider As Integer) As Integer
Declare Function IpAcqSnap Lib "IPC" (ByVal Destination As Integer) As Integer
Declare Function IpAcqTimed Lib "IPC" (ByVal DirPath As String, ByVal Prefix As String, ByVal StartNumber As Integer, ByVal Frames As Integer, ByVal Interval As Long) As Integer

'------------------------------------------------------------------
' Aoi manager functions
'------------------------------------------------------------------
Declare Function IpAoiCreateBox Lib "IPC" (lpRect As RECT) As Integer
Declare Function IpAoiCreateEllipse Lib "IPC" (lpRect As RECT) As Integer
Declare Function IpAoiCreateIrregular Lib "IPC" (lpPoint As POINTAPI, ByVal NumPoints As Integer) As Integer
Declare Function IpAoiShow Lib "IPC" (ByVal FrameType As Integer) As Integer
Declare Function IpAoiManager Lib "IPC" (ByVal FuncID As Integer, ByVal AoiName As String) As Integer
Declare Function IpAoiChangeName Lib "IPC" (ByVal oldName As String, ByVal newName As String) As Integer
Declare Function IpAoiMove Lib "IPC" (ByVal deltax As Integer, ByVal deltay As Integer) As Integer

'------------------------------------------------------------------
' Application functions
'------------------------------------------------------------------
Declare Function IpAppArrange Lib "IPC" (ByVal mode As Integer) As Integer
Declare Function IpAppCloseAll Lib "IPC" () As Integer
Declare Function IpAppExit Lib "IPC" () As Integer
Declare Function IpAppMaximize Lib "IPC" () As Integer
Declare Function IpAppMinimize Lib "IPC" () As Integer
Declare Function IpAppMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpAppRestore Lib "IPC" () As Integer
Declare Function IpAppSelectDoc Lib "IPC" (ByVal DocId As Integer) As Integer
Declare Function IpAppSize Lib "IPC" (ByVal cx As Integer, ByVal cy As Integer) As Integer
Declare Function IpAppUpdateDoc Lib "IPC" (ByVal DocId As Integer) As Integer
Declare Function IpAppHide Lib "IPC" (ByVal mode As Integer) As Integer
Declare Function IpAppRun Lib "IPC" (ByVal CommandLine As String, ByVal ShowMode As Integer, ByVal mode As Integer) As Integer
Declare Function IpAppMenuSelect Lib "IPC" (ByVal Id1 As Integer, ByVal Id2 As Integer, ByVal itemName As String, ByVal mode As Integer) As Integer
Declare Function IpAppGet Lib "IPC" (ByVal GetWhat As Integer, ByVal wParam As Integer, lpParam As Any) As Integer

'------------------------------------------------------------------
' Blob manager functions
'------------------------------------------------------------------
Declare Function IpBlbCount Lib "IPC" () As Integer
Declare Function IpBlbDelete Lib "IPC" () As Integer
Declare Function IpBlbEnableMeas Lib "IPC" (ByVal MeasurementType As Integer, ByVal bEnable As Integer) As Integer
Declare Function IpBlbLoadOutline Lib "IPC" (ByVal OutlineFile As String) As Integer
Declare Function IpBlbLoadSetting Lib "IPC" (ByVal SettingFile As String) As Integer
Declare Function IpBlbSaveData Lib "IPC" (ByVal DataFile As String, ByVal saveFlag As Integer) As Integer
Declare Function IpBlbSaveOutline Lib "IPC" (ByVal OutlineFile As String) As Integer
Declare Function IpBlbSaveSetting Lib "IPC" (ByVal SettingFile As String) As Integer
Declare Function IpBlbSetAttr Lib "IPC" (ByVal Attrib As Integer, ByVal value As Integer) As Integer
Declare Function IpBlbSetRange Lib "IPC" (ByVal StartRange As Integer, ByVal EndRange As Integer) As Integer
Declare Function IpBlbShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpBlbShowAutoClass Lib "IPC" (lpClassifiers As Integer, ByVal NumMeas As Integer, ByVal NumClass As Integer, ByVal bIterate As Integer, ByVal bShow As Integer) As Integer
Declare Function IpBlbShowCluster Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpBlbShowData Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpBlbShowHistogram Lib "IPC" (ByVal Measure As Integer, ByVal Bins As Integer, ByVal bShow As Integer) As Integer
Declare Function IpBlbShowObjectWindow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpBlbShowScatterGram Lib "IPC" (ByVal Measure1 As Integer, ByVal Measure2 As Integer, ByVal bShow As Integer) As Integer
Declare Function IpBlbShowSingleClass Lib "IPC" (ByVal NumMeasurements As Integer, lpBins As Single, ByVal NumClasses As Integer, ByVal bShow As Integer) As Integer
Declare Function IpBlbShowStatistics Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpBlbSplitObjects Lib "IPC" (ByVal bWatershed As Integer) As Integer
Declare Function IpBlbUpdate Lib "IPC" (ByVal bRedrawImage As Integer) As Integer
Declare Function IpBlbRemoveHoles Lib "IPC" () As Integer
Declare Function IpBlbSmoothObjects Lib "IPC" (ByVal smoothing As Integer) As Integer
Declare Function IpBlbSavePopDensities Lib "IPC" (ByVal DataFile As String, ByVal saveFlag As Integer) As Integer
Declare Function IpBlbSaveClasses Lib "IPC" (ByVal DataFile As String, ByVal saveFlag As Integer) As Integer
Declare Function IpBlbShowPopDens Lib "IPC" (ByVal OutlineFile As String, ByVal bShow As Integer) As Integer
Declare Function IpBlbMeasure Lib "IPC" () As Integer
Declare Function IpBlbFilter Lib "IPC" () As Integer
Declare Function IpBlbSetFilterRange Lib "IPC" (ByVal MeasurementType As Integer, ByVal Min As Single, ByVal Max As Single) As Integer
Declare Function IpBlbGet Lib "IPC" (ByVal GetWhat As Integer, ByVal wParam As Integer, lpParam As Any) As Integer
Declare Function IpBlbData Lib "IPC" (ByVal Measure As Integer, ByVal fromObj As Integer, ByVal toObj As Integer, Values As Single) As Integer

'------------------------------------------------------------------
' Calibration functions
'------------------------------------------------------------------
Declare Function IpCalLoad Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpCalSave Lib "IPC" (ByVal Filename As String) As Integer

Declare Function IpICalCreate Lib "IPC" () As Integer
Declare Function IpICalDestroy Lib "IPC" () As Integer
Declare Function IpICalMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpICalReset Lib "IPC" () As Integer
Declare Function IpICalSelect Lib "IPC" (ByVal szICal As String) As Integer
Declare Function IpICalSetName Lib "IPC" (ByVal szICal As String) As Integer
Declare Function IpICalSetOptDens Lib "IPC" (ByVal BlackLevel As Single, ByVal IncidentLevel As Single) As Integer
Declare Function IpICalSetPoints Lib "IPC" (lpICalPoints As Single, ByVal NumPoints As Integer, ByVal fitmode As Integer) As Integer
Declare Function IpICalSetSamples Lib "IPC" (ByVal NumSamples As Integer) As Integer
Declare Function IpICalSetUnitName Lib "IPC" (ByVal UnitName As String) As Integer
Declare Function IpICalShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpICalShowFormat Lib "IPC" (ByVal bOptDens As Integer) As Integer

Declare Function IpSCalCreate Lib "IPC" () As Integer
Declare Function IpSCalDestroy Lib "IPC" () As Integer
Declare Function IpSCalMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpSCalReset Lib "IPC" () As Integer
Declare Function IpSCalSelect Lib "IPC" (ByVal szSCal As String) As Integer
Declare Function IpSCalSetAngle Lib "IPC" (ByVal Angle As Single) As Integer
Declare Function IpSCalSetAspect Lib "IPC" (ByVal AspectRatio As Single) As Integer
Declare Function IpSCalSetName Lib "IPC" (ByVal szSCal As String) As Integer
Declare Function IpSCalSetOrigin Lib "IPC" (ByVal x As Single, ByVal y As Single) As Integer
Declare Function IpSCalSetUnit Lib "IPC" (ByVal x As Single, ByVal y As Single) As Integer
Declare Function IpSCalSetUnitName Lib "IPC" (ByVal UnitName As String) As Integer
Declare Function IpSCalShow Lib "IPC" (ByVal bShow As Integer) As Integer

'------------------------------------------------------------------
' Screen capture
'------------------------------------------------------------------
Declare Function IpCapArea Lib "IPC" (lpRect As RECT, ByVal bCursor As Integer) As Integer
Declare Function IpCapFile Lib "IPC" (ByVal FileFormat As String, ByVal Directory As String, ByVal Prefix As String, ByVal Number As Integer) As Integer
Declare Function IpCapHotKey Lib "IPC" (ByVal KeyName As String, ByVal bShift As Integer, ByVal bCtrl As Integer, ByVal bAlt As Integer) As Integer
Declare Function IpCapWindow Lib "IPC" (ByVal Title As String, ByVal bClientOnly As Integer, ByVal bCursor As Integer) As Integer

'------------------------------------------------------------------
' Color transformation functions
'------------------------------------------------------------------
Declare Function IpCmChannelExtract Lib "IPC" (ByVal cmColor As Integer, ByVal cmComp As Integer, ByVal Channel As Integer) As Integer
Declare Function IpCmChannelMerge Lib "IPC" (ByVal WsId As Integer, ByVal cmColor As Integer, ByVal Channel As Integer) As Integer
Declare Function IpCmTransform Lib "IPC" (ByVal cmOut As Integer, ByVal cmIn As Integer, ByVal bNewImage As Integer) As Integer

'------------------------------------------------------------------
' Document window functions
'------------------------------------------------------------------
Declare Function IpDocClose Lib "IPC" () As Integer
Declare Function IpDocMaximize Lib "IPC" () As Integer
Declare Function IpDocMinimize Lib "IPC" () As Integer
Declare Function IpDocMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpDocRestore Lib "IPC" () As Integer
Declare Function IpDocSize Lib "IPC" (ByVal cx As Integer, ByVal cy As Integer) As Integer

'------------------------------------------------------------------
' Fast fourier transform functions
'------------------------------------------------------------------
Declare Function IpFftForward Lib "IPC" (ByVal DisplayType As Integer, ByVal bFullFft As Integer) As Integer
Declare Function IpFftHiPass Lib "IPC" (ByVal CType As Integer, ByVal Transition As Integer, ByVal PreserveNil As Integer) As Integer
Declare Function IpFftInverse Lib "IPC" (ByVal WsId As Integer, ByVal PreserveData As Integer) As Integer
Declare Function IpFftLoad Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpFftLoPass Lib "IPC" (ByVal CType As Integer, ByVal Transition As Integer) As Integer
Declare Function IpFftSave Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpFftSpikeCut Lib "IPC" (ByVal CType As Integer, ByVal Transition As Integer, ByVal Symmetrical As Integer) As Integer
Declare Function IpFftSpikeBoost Lib "IPC" (ByVal CType As Integer, ByVal Transition As Integer, ByVal Symmetrical As Integer) As Integer
Declare Function IpFftShow Lib "IPC" (ByVal bShow As Integer) As Integer

'------------------------------------------------------------------
' Spatial filtering
'------------------------------------------------------------------
Declare Function IpFltClose Lib "IPC" (ByVal Shape As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltConvolveKernel Lib "IPC" (ByVal KernelName As String, ByVal Strength As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltDilate Lib "IPC" (ByVal Shape As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltErode Lib "IPC" (ByVal Shape As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltExtractBkgnd Lib "IPC" (ByVal BrightOnDark As Integer, ByVal ObjectSize As Integer) As Integer
Declare Function IpFltFlatten Lib "IPC" (ByVal BrightOnDark As Integer, ByVal ObjectSize As Integer) As Integer
Declare Function IpFltHiPass Lib "IPC" (ByVal Size As Integer, ByVal Strength As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltLaplacian Lib "IPC" (ByVal Size As Integer, ByVal Strength As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltLoPass Lib "IPC" (ByVal Size As Integer, ByVal Strength As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltMedian Lib "IPC" (ByVal Size As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltOpen Lib "IPC" (ByVal Shape As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltPhase Lib "IPC" () As Integer
Declare Function IpFltRoberts Lib "IPC" () As Integer
Declare Function IpFltSharpen Lib "IPC" (ByVal Size As Integer, ByVal Strength As Integer, ByVal Passes As Integer) As Integer
Declare Function IpFltSobel Lib "IPC" () As Integer
Declare Function IpFltThin Lib "IPC" (ByVal Threshold As Integer) As Integer
Declare Function IpFltWatershed Lib "IPC" (ByVal Threshold As Integer) As Integer
Declare Function IpFltShow Lib "IPC" (ByVal bShow As Integer) As Integer

'------------------------------------------------------------------
' Gallery
'------------------------------------------------------------------
Declare Function IpGalAdd Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpGalChangeDescription Lib "IPC" (ByVal DescriptionType As Integer, ByVal Description As String) As Integer
Declare Function IpGalDelete Lib "IPC" (ByVal GalleryName As String) As Integer
Declare Function IpGalGetActive Lib "IPC" (ByVal GalleryName As String) As Integer
Declare Function IpGalNew Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpGalOpen Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpGalOpenPhotoCD Lib "IPC" (ByVal DriveLetter As String, ByVal GalleryName As String, ByVal Resolution As Integer) As Integer
Declare Function IpGalRemove Lib "IPC" (ByVal bFromDisk As Integer) As Integer
Declare Function IpGalSetActive Lib "IPC" (ByVal GalleryId As Integer) As Integer
Declare Function IpGalShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpGalSort Lib "IPC" (ByVal bByName As Integer, ByVal bAscending As Integer) As Integer
Declare Function IpGalTag Lib "IPC" (ByVal Slot As Integer, ByVal tag As Integer) As Integer
Declare Function IpGalUpdate Lib "IPC" () As Integer
Declare Function IpGalImageOpen Lib "IPC" (ByVal Slot As Integer) As Integer
Declare Function IpGalClose Lib "IPC" () As Integer

'------------------------------------------------------------------
' Histogram functions
'------------------------------------------------------------------
Declare Function IpHstEqualize Lib "IPC" (ByVal Method As Integer) As Integer
Declare Function IpHstCreate Lib "IPC" () As Integer
Declare Function IpHstDestroy Lib "IPC" () As Integer
Declare Function IpHstMaximize Lib "IPC" () As Integer
Declare Function IpHstMinimize Lib "IPC" () As Integer
Declare Function IpHstMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpHstRestore Lib "IPC" () As Integer
Declare Function IpHstSave Lib "IPC" (ByVal Filename As String, ByVal bAppend As Integer) As Integer
Declare Function IpHstScale Lib "IPC" (ByVal bVert As Integer, ByVal bAuto As Integer, ByVal FrmRng As Single, ByVal ToRng As Single) As Integer
Declare Function IpHstSelect Lib "IPC" (ByVal HstId As Integer) As Integer
Declare Function IpHstSetAttr Lib "IPC" (ByVal AttrType As Integer, ByVal AttrValue As Integer) As Integer
Declare Function IpHstSize Lib "IPC" (ByVal cx As Integer, ByVal cy As Integer) As Integer
Declare Function IpHstUpdate Lib "IPC" () As Integer

'------------------------------------------------------------------
' Lookup Table
'------------------------------------------------------------------
Declare Function IpLutApply Lib "IPC" () As Integer
Declare Function IpLutBinarize Lib "IPC" (ByVal MinRange As Integer, ByVal MaxRange As Integer, ByVal WhiteOnBlack As Integer) As Integer
Declare Function IpLutLoad Lib "IPC" (ByVal Filename As String) As Integer
Declare Function IpLutReset Lib "IPC" (ByVal Channel As Integer, ByVal mode As Integer) As Integer
Declare Function IpLutSave Lib "IPC" (ByVal Filename As String, ByVal Description As String) As Integer
Declare Function IpLutSetAttr Lib "IPC" (ByVal AttrType As Integer, ByVal AttrValue As Integer) As Integer
Declare Function IpLutSetControl Lib "IPC" (ByVal ControlType As Integer, Lut As Integer, ByVal Count As Integer) As Integer
Declare Function IpLutShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpLutStretch Lib "IPC" (ByVal in1 As Single, ByVal in2 As Single, ByVal out1 As Single, ByVal out2 As Single, ByVal mode As Integer) As Integer

'------------------------------------------------------------------
' Measurements
'------------------------------------------------------------------
Declare Function IpMeasAttr Lib "IPC" (ByVal bAttr As Integer, ByVal value As Integer) As Integer
Declare Function IpMeasDelete Lib "IPC" (ByVal bMeasurement As Integer) As Integer
Declare Function IpMeasLoadOutline Lib "IPC" (ByVal OutlineFile As String) As Integer
Declare Function IpMeasMaximize Lib "IPC" () As Integer
Declare Function IpMeasMinimize Lib "IPC" () As Integer
Declare Function IpMeasMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpMeasRestore Lib "IPC" () As Integer
Declare Function IpMeasSaveData Lib "IPC" (ByVal DataFile As String, ByVal mode As Integer) As Integer
Declare Function IpMeasSaveOutline Lib "IPC" (ByVal OutlineFile As String) As Integer
Declare Function IpMeasShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpMeasSize Lib "IPC" (ByVal cx As Integer, ByVal cy As Integer) As Integer
Declare Function IpMeasTool Lib "IPC" (ByVal tool As Integer) As Integer
Declare Function IpMeasTag Lib "IPC" (ByVal toolIndex As Integer, ByVal OnOff As Integer) As Integer

'------------------------------------------------------------------
' Arithmetics and logical operations
'------------------------------------------------------------------
Declare Function IpOpBkgndCorrect Lib "IPC" (ByVal WsBackId As Integer, BlackLevel As Integer, ByVal bNewImage As Integer) As Integer
Declare Function IpOpBkgndSubtract Lib "IPC" (ByVal WsBackId As Integer, ByVal bNewImage As Integer) As Integer
Declare Function IpOpImageArithmetics Lib "IPC" (ByVal WsId As Integer, ByVal Number As Single, ByVal OpaCode As Integer, ByVal bNewImage As Integer) As Integer
Declare Function IpOpImageLogic Lib "IPC" (ByVal WsId As Integer, ByVal OplCode As Integer, ByVal bNewImage As Integer) As Integer
Declare Function IpOpNumberArithmetics Lib "IPC" (ByVal Number As Single, ByVal OpaCode As Integer, ByVal bNewImage As Integer) As Integer
Declare Function IpOpNumberLogic Lib "IPC" (ByVal Number As Integer, ByVal OplCode As Integer, ByVal bNewImage As Integer) As Integer
Declare Function IpOpShow Lib "IPC" (ByVal bShow) As Integer

'------------------------------------------------------------------
' Palette tool
'------------------------------------------------------------------
Declare Function IpPalShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpPalSetPaletteColor Lib "IPC" (ByVal PaletteIndex As Integer, ByVal Red As Integer, ByVal Green As Integer, ByVal Blue As Integer) As Integer
Declare Function IpPalSetGrayBrush Lib "IPC" (ByVal bForeGround As Integer, ByVal GrayIndex As Integer) As Integer
Declare Function IpPalSetPaletteBrush Lib "IPC" (ByVal bForeGround As Integer, ByVal PaletteIndex As Integer) As Integer
Declare Function IpPalSetRGBBrush Lib "IPC" (ByVal bForeGround As Integer, ByVal Red As Integer, ByVal Green As Integer, ByVal Blue As Integer) As Integer

'------------------------------------------------------------------
' Line profile
'------------------------------------------------------------------
Declare Function IpProfCreate Lib "IPC" () As Integer
Declare Function IpProfDestroy Lib "IPC" () As Integer
Declare Function IpProfLineMove Lib "IPC" (ByVal x1 As Integer, ByVal y1 As Integer, ByVal x2 As Integer, ByVal y2 As Integer) As Integer
Declare Function IpProfMaximize Lib "IPC" () As Integer
Declare Function IpProfMinimize Lib "IPC" () As Integer
Declare Function IpProfMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpProfRestore Lib "IPC" () As Integer
Declare Function IpProfSave Lib "IPC" (ByVal Filename As String, ByVal bAppend As Integer) As Integer
Declare Function IpProfSelect Lib "IPC" (ByVal ProfId As Integer) As Integer
Declare Function IpProfSetAttr Lib "IPC" (ByVal AttrType As Integer, ByVal AttrValue As Integer) As Integer
Declare Function IpProfSize Lib "IPC" (ByVal cx As Integer, ByVal cy As Integer) As Integer
Declare Function IpProfUpdate Lib "IPC" () As Integer

'------------------------------------------------------------------
' Printing
'------------------------------------------------------------------
Declare Function IpPrtHalftone Lib "IPC" (ByVal bUsePrtHalf As Integer, ByVal bUsePrtScaling As Integer, ByVal HalfType As Integer, ByVal HaltOpt As Integer) As Integer
Declare Function IpPrtPage Lib "IPC" (ByVal PageNo As Integer, ByVal bUsePrtComp As Integer, ByVal Copies As Integer) As Integer
Declare Function IpPrtSize Lib "IPC" (ByVal full As Integer, ByVal center As Integer, ByVal top As Single, ByVal lft As Single, ByVal wdth As Single, ByVal Height As Single, ByVal Smooth As Integer) As Integer

'------------------------------------------------------------------
' Pseudo color
'------------------------------------------------------------------
Declare Function IpPcLoad Lib "IPC" (ByVal PseudoColorFile As String) As Integer
Declare Function IpPcSave Lib "IPC" (ByVal PseudoColorFile As String) As Integer
Declare Function IpPcSetColor Lib "IPC" (ByVal DivNo As Integer, ByVal Red As Integer, ByVal Green As Integer, ByVal Blue As Integer) As Integer
Declare Function IpPcSetDivisions Lib "IPC" (ByVal Divisions As Integer) As Integer
Declare Function IpPcSetRange Lib "IPC" (ByVal DivNo As Integer, ByVal FromVal As Integer, ByVal ToVal As Integer) As Integer
Declare Function IpPcShow Lib "IPC" (ByVal bShow As Integer) As Integer

'------------------------------------------------------------------
' scan functions
'------------------------------------------------------------------
Declare Function IpScanShow Lib "IPC" () As Integer

'------------------------------------------------------------------
' color segmentation functions
'------------------------------------------------------------------
Declare Function IpSegCreateMask Lib "IPC" (ByVal MaskType As Integer) As Integer
Declare Function IpSegLoad Lib "IPC" (ByVal ColorRangesFile As String) As Integer
Declare Function IpSegMerge Lib "IPC" (ByVal ColorRangesFile As String) As Integer
Declare Function IpSegReset Lib "IPC" () As Integer
Declare Function IpSegSave Lib "IPC" (ByVal ColorRangesFile As String, ByVal bHSI As Integer) As Integer
Declare Function IpSegSelect Lib "IPC" (ByVal mode As Integer, ByVal Sensit As Integer) As Integer
Declare Function IpSegShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpSegPreview Lib "IPC" (ByVal bShow As Integer) As Integer

'------------------------------------------------------------------
' Workspace functions
'------------------------------------------------------------------
Declare Function IpWsChangeDescription Lib "IPC" (ByVal DescriptionType As Integer, ByVal Description As String) As Integer
Declare Function IpWsChangeInfo Lib "IPC" (ByVal InfoType As Integer, ByVal Info As Integer) As Integer
Declare Function IpWsConvertFile Lib "IPC" (ByVal DstFile As String, ByVal DstFmt As String, ByVal SrcFile As String, ByVal SrcFmt As String, ByVal Comp As Integer, ByVal imClass As Integer, ByVal HalftType As Integer, ByVal HalfOpt As Integer, ByVal Dpi As Integer) As Integer
Declare Function IpWsConvertToBilevel Lib "IPC" (ByVal HalftoneType As Integer, ByVal Screen As Integer, ByVal OutputDpi As Integer) As Integer
Declare Function IpWsConvertToFloat Lib "IPC" () As Integer
Declare Function IpWsConvertToGray Lib "IPC" () As Integer
Declare Function IpWsConvertToGray12 Lib "IPC" () As Integer
Declare Function IpWsConvertToPaletteMColor Lib "IPC" () As Integer
Declare Function IpWsConvertToPaletteMedian Lib "IPC" (ByVal StartIndex As Integer, ByVal NumColors As Integer) As Integer
Declare Function IpWsConvertToRGB Lib "IPC" () As Integer
Declare Function IpWsCopy Lib "IPC" () As Integer
Declare Function IpWsCreate Lib "IPC" (ByVal cx As Integer, ByVal cy As Integer, ByVal Dpi As Integer, ByVal Class As Integer) As Integer
Declare Function IpWsCreateFromClipboard Lib "IPC" () As Integer
Declare Function IpWsDuplicate Lib "IPC" () As Integer
Declare Function IpWsFill Lib "IPC" (ByVal FillType As Integer, ByVal ColorType As Integer, ByVal Transparency As Integer) As Integer
Declare Function IpWsFillPattern Lib "IPC" (ByVal PatternFile As String) As Integer
Declare Function IpWsGetId Lib "IPC" (ByVal WsName As String, Id As Integer) As Integer
Declare Function IpWsGetName Lib "IPC" (ByVal Id As Integer, ByVal WsName As String, ByVal WsNameBufSize As Integer) As Integer
Declare Function IpWsLoad Lib "IPC" (ByVal Filename As String, ByVal FileFormat As String) As Integer
Declare Function IpWsLoadNumber Lib "IPC" (ByVal Number As Integer) As Integer
Declare Function IpWsLoadPreview Lib "IPC" (ByVal Filename As String, ByVal FileFormat As String, ByVal xLeft As Integer, ByVal yTop As Integer, ByVal xRight As Integer, ByVal yBottom As Integer) As Integer
Declare Function IpWsMove Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpWsOrient Lib "IPC" (ByVal OrientType As Integer) As Integer
Declare Function IpWsPan Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpWsPaste Lib "IPC" (ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function IpWsRedo Lib "IPC" (ByVal Number As Integer) As Integer
Declare Function IpWsReload Lib "IPC" () As Integer
Declare Function IpWsRotate Lib "IPC" (ByVal Angle As Integer, ByVal Anchor As Integer) As Integer
Declare Function IpWsRulerShow Lib "IPC" (ByVal bShow As Integer) As Integer
Declare Function IpWsRulerType Lib "IPC" (ByVal RulerType As Integer) As Integer
Declare Function IpWsSave Lib "IPC" () As Integer
Declare Function IpWsSaveAs Lib "IPC" (ByVal Filename As String, ByVal FileFormat As String) As Integer
Declare Function IpWsSaveEx Lib "IPC" (ByVal Fil As String, ByVal form As String, ByVal Comp As Integer, ByVal BPP As Integer) As Integer
Declare Function IpWsScale Lib "IPC" (ByVal cx As Integer, ByVal cx As Integer, ByVal bSmooth As Integer) As Integer
Declare Function IpWsTestStrips Lib "IPC" (ByVal col As Integer, ByVal lin As Integer, ByVal typ As Integer, ByVal Min As Integer, ByVal Max As Integer, ByVal Reduce As Integer, ByVal R As Integer, ByVal G As Integer, ByVal B As Integer) As Integer
Declare Function IpWsTestStrips2 Lib "IPC" (ByVal col As Integer, ByVal lin As Integer, ByVal T1 As Integer, ByVal M1 As Integer, ByVal M1 As Integer, ByVal T2 As Integer, ByVal M2 As Integer, ByVal M2 As Integer, ByVal Reduc As Integer, ByVal R As Integer, ByVal G As Integer, ByVal B As Integer) As Integer
Declare Function IpWsTestStripsHalftone Lib "IPC" (ByVal AllTypes As Integer, ByVal Color As Integer, HalfTypes As Integer, HalfScreen As Integer, ByVal OutputDpi As Integer, ByVal Reduction As Integer) As Integer
Declare Function IpWsUndo Lib "IPC" (ByVal Number As Integer) As Integer
Declare Function IpWsZoom Lib "IPC" (ByVal PercentZoom As Integer) As Integer
Declare Function IpWsLoadSetRes Lib "IPC" (ByVal Number As Integer) As Integer


'------------------------------------------------------------
'   Template Mode Functions
'------------------------------------------------------------

Declare Function IpTemplateMode Lib "IPC" (ByVal OnOff As Integer) As Integer

Declare Function IpMacroRun Lib "IPC" (ByVal MacroName As String, ByVal ScriptFile As String) As Integer
Declare Function IpMacroLoad Lib "IPC" (ByVal MacroName As String) As Integer
Declare Function IpMacroStop Lib "IPC" (ByVal messageStr As String, ByVal mode As Integer) As Integer

Declare Function IpGetTrack Lib "IPC" (Tracking As TRACK, ByVal Caption As String) As Integer
Declare Function IpWsCreateFromVri Lib "IPC" (ByVal Vri As Integer, ByVal DocName As String) As Integer

Declare Function IpStAutoName Lib "IPC" (ByVal AutoForm As String, ByVal Number As Integer, ByVal Filename As String) As Integer
Declare Function IpStSearchDir Lib "IPC" (ByVal Directory As String, ByVal Filter As String, ByVal Number As Integer, ByVal Filename As String) As Integer
Declare Function IpStGetName Lib "IPC" (ByVal Title As String, ByVal Default As String, ByVal Filter As String, ByVal Filename As String) As Integer

