#===================================================================
#
#   Make file for sample32.c script.
#   Created 1992 Multi-Net Communications
#
#===================================================================

LFLAGS   = /NOE /NOD
LINK    = LINK386  $(LFLAGS)
CC         = icc /c /Ge /Gd- /Se /Re /ss /Ms  /Gm+

.c.lst:
    $(CC) -Fc$*.lst -Fo$*.obj $*.c

.c.obj:
    $(CC) -Fo$*.obj $*.c

.ipf.hlp:
        ipfc $*.ipf /W3

.itl.hlp:
        cc  -P $*.itl
        ipfc $*.i
        del $*.i

.rc.res:
        rc -r $*.rc


HEADERS = cpmcomm.h

LIBS    = DDE4MBS + os2386 + cpmcom32
#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------
ALL_OBJ1 = sample.obj

all: sample32.exe

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------
sample32.lnk: sample32.mak
    echo $(ALL_OBJ1)             > sample32.lnk
    echo sample32.exe           >> sample32.lnk
    echo sample32.map           >> sample32.lnk
    echo $(LIBS)                >> sample32.lnk
    echo sample32.def           >> sample32.lnk



#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

sample32.obj: sample32.c $(HEADERS)

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

sample32.exe: $(ALL_OBJ1) $(ALL_OBJ2) sample32.def sample32.lnk
    $(LINK) @sample32.lnk
