@ECHO OFF
@CLS
REM                         SAT.BAT - for KeyMagic & Multi-Poll        8/31/92
REM
REM   *************************************************************************
REM   This file is named SAT.BAT. It is the "driver" batch 
REM   file and scheduler for other Multi-Site batch files used
REM   by the Satellite in the Multi-Site demo. %1 is replaced
REM   by XM, if specified.
REM   *************************************************************************
:BEGIN
REM   *************************************************************************
REM    The following line performs housekeeping functions at the 
REM    Satellite to prepare the data files for the Multi-Site demo
REM   *************************************************************************
REM
CALL SATMNT    
REM   *************************************************************************
REM    The following line runs Ticket Entry, End of Day posting, and
REM    creates the Satellite Transmission file for store 1 using
REM    KeyMagic to supply the "keystroke file" TIK&PST.KEY.
REM
REM   *************************************************************************
REM
@ECHO OFF
CALL SMSG1
CALL KMRUN PS  TIK&PST.KEY %1
REM   *************************************************************************
REM    The following line runs Multi-Poll, using the activity SNDTR, to
REM    send the Satellite Transmission file to the HUB.
REM
REM   *************************************************************************
REM
CALL SMSG2
@ECHO OFF
MPDEMO SNDTR
CALL SMSG3
REM   *************************************************************************
REM    The following line runs Multi-Poll in the slave mode to receive
REM    the Hub Transmission file from the HUB.
REM   *************************************************************************
REM
@ECHO OFF
MPDEMO -S
CALL SMSG4
REM   *************************************************************************
REM    The following line runs Import from Hub using KeyMagic to 
REM    supply the "keystroke file" IMPHUB.KEY.
REM   *************************************************************************
REM
@ECHO OFF
CALL KMRUN PS IMPHUB.KEY %1
REM   *************************************************************************
REM   Loop back and restart the Multi-Site demo.
REM   *************************************************************************
REM
@ECHO OFF
CALL SMSG5
@ECHO OFF
GOTO BEGIN
:END
