@Echo off
REM                         KMRUN.BAT                                  12/31/92
REM
REM       This batch file executes Synchronics and RealWorld software. It
REM       contains the COBOL switch for unattended processing, and the
REM       command lines for KeyMagic used both with and without XM. The 
REM       -l switch invokes the learn mode of KeyMagic.
REM
REM
REM       The following parameters are used in KMRUN:
REM
REM       %1   is replaced by the Synchronics or RealWorld package ID to run.
REM       %2   is replaced by the keystroke file to be used with KeyMagic.
REM       %3   is replaced by the XM or the KeyMagic learn option, if specified.
REM       %4   is replaced by the KeyMagic learn option, if specified.
REM
REM       (+7) in the Set COBSW line is the unattended posting switch.
REM        
:CHKSYN1
SET PKGID=""
FOR %%P IN (AP,ap,AR,ar,GL,gl,IC,ic,JC,jc,OE,oe,PI,pi,PO,po,PR,pr,RWC,rwc,SA,sa,SM,sm,TB,tb) DO IF "%%P"=="%1" GOTO RWPKG
FOR %%P IN (CL,cl,EI,ei,IS,is,OS,os,PA,pa,PS,ps,SYN,syn) DO IF "%%P"=="%1" GOTO SYNPKG
FOR %%P IN (FIXAP,fixap,FIXAR,fixar,FIXGL,fixgl,FIXJC,fixjc,FIXPI,fixpi) DO IF "%%P"=="%1" GOTO RWPKG
FOR %%P IN (FIXPO,fixpo,FIXPR,fixpr,FIXSA,fixsa,FIXSM,fixsm,FIXTB,fixtb) DO IF "%%P"=="%1" GOTO RWPKG
FOR %%P IN (FIXCL,fixcl,FIXPA,fixpa,FIXPS,fixps) DO IF "%%P"=="%1" GOTO SYNPKG
FOR %%P IN (FIXIC,fixic,FIXOE,fixoe) DO IF "%%P"=="%1" GOTO FINDPKG
GOTO ERROR

:FINDPKG
FOR %%P IN (FIXIC,fixic) DO IF EXIST IS.* GOTO SYNPKG
FOR %%P IN (FIXOE,fixoe) DO IF EXIST OS.* GOTO SYNPKG
GOTO RWPKG

:SYNPKG
SET PKGID=SYN
GOTO CHKSYN2

:RWPKG
SET PKGID=RW
GOTO CHKSYN2

:CHKSYN2
FOR %%P IN (XM,xm,"",-L,-l) DO IF "%%P"=="%2" GOTO ERROR

:CHKSYN3
SET KMLEARN=N
FOR %%P IN (XM,xm) DO IF "%%P"=="%3" GOTO XMCHECK
FOR %%P IN (-L,-l) DO IF "%%P"=="%3" SET KMLEARN=Y
GOTO KMCHECK
GOTO ERROR
:XMCHECK
IF EXIST %3.EXE GOTO CHKSYN4
GOTO ERROR

:CHKSYN4
FOR %%P IN (-L,-l) DO IF "%%P"=="%4" SET KMLEARN=Y

:KMCHECK
IF "%KMLEARN%"=="N" GOTO CHECKKEY
IF EXIST KMDEMO.EXE GOTO SYNTAXOK
GOTO ERROR

:CHECKKEY
IF EXIST %2 GOTO SYNTAXOK
IF NOT EXIST %2.KEY GOTO ERROR

:SYNTAXOK
Set COBDIR=.
Set COBSW=+M+M2+7
KMDEMO -Q

:BTCHECK
SET BTFOUND=N
IF NOT EXIST BREQUEST.EXE GOTO PKGTST
IF EXIST PATHFILE.IDX GOTO PKGTST
SET BTFOUND=Y
BREQUEST /D:12000

:PKGTST
IF NOT "%KMLEARN%"=="Y" KMDEMO -Q -W -PT %2
IF "%KMLEARN%"=="Y" KMDEMO -Q -R %2
IF "%PKGID%"=="SYN" GOTO SYN

:RW
FOR %%P IN (XM,xm) DO IF "%%P"=="%3" GOTO XM
Windows
run -f %1
Goto Finish
:XM
Windows /%3
%3 +J +R +K Run -f %1
:Finish
Command /C EXIT
Clrwind
IF "%KMLEARN%"=="Y" KMDEMO -RE
IF "%BTFOUND%"=="Y" BUTIL -STOP
GOTO CLEANUP

:SYN
FOR %%P IN (XM,xm) DO IF "%%P"=="%3" GOTO SYNXM
IF EXIST WINSML.EXE GOTO SMLWIND
WINSYN
GOTO RUN
:SMLWIND
WINSML
:RUN
RUNSYN -F %1
GOTO SYNDONE
:SYNXM
WINSYN /%3
%3 +J +R +K RUNSYN -F %1
:SYNDONE
COMMAND /C EXIT
CLRSYN
IF "%KMLEARN%"=="Y" KMDEMO -RE
IF "%BTFOUND%"=="Y" BUTIL -STOP
GOTO CLEANUP

:ERROR
Echo.
Echo.
Echo You must type a valid batch file name and keystroke filename to start up
Echo a Synchronics or RealWorld package using KMRUN. To use KMRUN type:
Echo.
Echo                   KMRUN xx keyfile [xm] [-l]
Echo.
Echo where "xx" is the name of a valid Synchronics or RealWorld package, 
Echo "keyfile" is the name of a valid keystroke file, "xm" is the optional
Echo Microfocus Extended Memory Manager, and "-l" is the optional switch to
Echo use the KeyMagic learn mode. (To run File Utilities, use FIXxx for the
Echo package).An example of using KMRUN with XM would be:
Echo.
Echo                   KMRUN PS EODSAT01.KEY XM
Echo.
Echo An example of using KMRUN with the KeyMagic learn switch would be:
Echo.
Echo                   KMRUN PS EODSAT01.KEY -L    
Echo.
Echo.

:CLEANUP
rem ******************************************IF "%PKGID%"=="SYN"GOTO SYNCLEAN
If not exist LINK\*.* goto work
cd LINK
..\RWCDEL *.*
cd ..
:work
If not exist RWWRK\*.* goto DONE
cd RWWRK
..\RWCDEL *.*
cd ..
GOTO DONE

:SYNCLEAN
SYNDEL LINK\*.*
SYNDEL RWWRK\*.*
GOTO DONE

:DONE
