@ECHO OFF
REM                         INSTALL.BAT  - KeyMagic & Multipoll      05/10/93
REM
REM   ************************************************************************
REM   This is the installation procedure for the Satellite portion of the 
REM   Synchronics 6.5 Multi-Site demo. To use INSTALL type:
REM
REM                INSTALL [drive:directory]
REM
REM   If you do not specify a drive letter and directory name, the   
REM   Multi-Site Demo SAT programs and data will be installed in the
REM   default directory  C:\SAT
REM   ************************************************************************

@Echo off
@CLS
SET MSD=%1
IF "%1"=="" SET MSD=C:\SAT

:START
@echo Synchronics (R) Installation Procedure (Version 1.0).
@echo (C) Copyright 1992 - 1993 by Synchronics, Inc.  All rights reserved. 
@echo Please wait ...
@ECHO

:TESTDIR
CTTY NUL
IF NOT EXIST %MSD%\NUL MD %MSD%
@ECHO "File Creation Test" > SATINST.$$$
copy SATINST.$$$ %MSD%
del SATINST.$$$
CTTY CON
IF NOT EXIST %MSD%\SATINST.$$$ GOTO ERR
DEL %MSD%\SATINST.$$$

IF "%1"=="" GOTO DEFAULT
GOTO CUSTOM

:DEFAULT
@ECHO The Multi-Site Demo SAT programs and data will be installed in the
@ECHO default directory  C:\SAT.
@ECHO
@ECHO To install the programs and data in a different directory, enter the
@ECHO drive letter and name of the directory which you want to use. For
@ECHO example, if you type  C:\SAT, the demo will be installed onto drive 
@ECHO C: in the directory  SAT. If the directory does not already exist,
@ECHO the installation will create it for you.
@ECHO
ECHO If you wish to exit this procedure, press CTRL/C, otherwise ...
Pause

GOTO INSTALL


:CUSTOM
@ECHO The Multi-Site Demo SAT programs and data will be installed in
@ECHO the directory  %1.
@ECHO
@ECHO If the directory does not already exist, the installation will
@ECHO create it for you.
@ECHO
ECHO If you wish to exit this procedure, press CTRL/C, otherwise ...
Pause


:INSTALL
@ECHO Unzipping files . . .
CTTY NUL
PKUNZIP -DO SAT.ZIP %MSD%
CTTY CON

GOTO DONE


:ERR
CTTY NUL
RMDIR %MSD%
DEL %MSD%
CTTY CON
@ECHO
@ECHO            ERROR - %MSD% is an invalid drive or directory
@ECHO                    name. Please refer to the Demo and 
@ECHO                    Installation guide for more information.
@ECHO
@ECHO               *****  Installation ending on ERROR  *****
GOTO END

:DONE
ECHO
ECHO            The Synchronics Version 6.5 Multi-Site Satellite Demo
ECHO            has been installed in the %MSD% directory. Refer to
ECHO            the Demo and Installation Guide for information on
ECHO            connecting to the Hub and running the Demo.
@REM
:END
