@ECHO OFF
@CLS
REM                          HUB.BAT  - for KeyMagic & Multi-Poll      8/28/92
REM
REM   *************************************************************************
REM   This file is named HUB.BAT. It is the "driver" batch 
REM   file and scheduler for other Multi-Site batch files used
REM   in the Multi-Site demo. %1 is replaced by XM, if specified.
REM
:HOUSEKEEPING
REM   *************************************************************************
REM    The following line runs the batch file HUBMNT to maintain
REM    data files for the Multi-Site demo.
CALL HUBMNT
CALL HMSG1
REM   *************************************************************************
REM    The following line runs customer and item maintenance at the
REM    HUB, using KeyMagic to supply the "keystroke file" MAINT.KEY
REM   *************************************************************************
CALL KMRUN PS MAINT %1
CALL HMSG2
@ECHO OFF
REM   *************************************************************************
REM    The following line runs Multi-Poll in the slave mode to receive
REM    the Satellite Transmission file from the remote store.
REM   *************************************************************************
REM
MPDEMO -S
CALL HMSG3
@ECHO OFF
REM   *************************************************************************
REM    The following line runs Import from Satellite, End of Day
REM    for store 1, and a Partial Search for changes, using KeyMagic
REM    to supply the "keystroke file" PROSAT.KEY.
REM   *************************************************************************
REM
IF NOT EXIST PSSATF00.001 CALL SATFILE
CALL KMRUN PS PROSAT %1
CALL HMSG4
@ECHO OFF
REM   *************************************************************************
REM    The following line runs Multi-Poll, using the activity HBSND, to
REM    send the Hub Transmission file to the remote site.
REM   *************************************************************************
REM
IF NOT EXIST PSHUBF00.DAT CALL CHNGFILE
IF NOT EXIST PSHUBF00.IDX CALL CHNGFILE
MPDEMO SEND
CALL HMSG5
@ECHO OFF
REM
CALL HMSG6
@ECHO OFF
GOTO HOUSEKEEPING
:END
