@ECHO OFF
REM                         INSTALL.BAT - for KeyMagic & Multi-Poll   5/10/93
REM
REM   ************************************************************************
REM   This is the installation procedure for the HUB portion of the 
REM   Synchronics 6.5 Multi-Site demo. To use INSTALL type:
REM
REM                INSTALL [drive:directory]
REM
REM   If you do not specify a drive letter and directory name, the   
REM   Multi-Site Demo HUB programs and data will be installed in the
REM   default directory  C:\HUB
REM   ************************************************************************

@Echo off
@CLS
SET MSD=%1
IF "%1"=="" SET MSD=C:\HUB

:START
@echo Synchronics (R) Installation Procedure (Version 1.0).
@echo (C) Copyright 1992 - 1993 by Synchronics, Inc.  All rights reserved. 
@echo Please wait ...
@ECHO

:TESTDIR
CTTY NUL
IF NOT EXIST %MSD%\NUL MD %MSD%
@ECHO "File Creation Test" > HUBINST.$$$
copy HUBINST.$$$ %MSD%
del HUBINST.$$$
CTTY CON
IF NOT EXIST %MSD%\HUBINST.$$$ GOTO ERR
DEL %MSD%\HUBINST.$$$

IF "%1"=="" GOTO DEFAULT
GOTO CUSTOM

:DEFAULT
@ECHO The Multi-Site Demo HUB programs and data will be installed in the default
@ECHO directory  C:\HUB.
@ECHO
@ECHO To install the programs and data in a different directory,
@ECHO enter the drive letter and name of the directory which you want to use. For
@ECHO example, if you type  C:\HUB, the demo will be installed onto drive  C: in
@ECHO the directory  HUB. If the directory does not already exist, the installation
@ECHO will create it for you.
@ECHO
ECHO If you wish to exit this procedure, press CTRL/C, otherwise ...
Pause

GOTO INSTALL


:CUSTOM
@ECHO The Multi-Site Demo HUB programs and data will be installed in
@ECHO the directory  %1.
@ECHO
@ECHO If the directory does not already exist, the installation will
@ECHO create it for you.
@ECHO
ECHO If you wish to exit this procedure, press CTRL/C, otherwise ...
Pause


:INSTALL
@ECHO Unzipping files . . .
CTTY NUL
PKUNZIP -DO HUB.ZIP %MSD%
CTTY CON

GOTO DONE


:ERR
CTTY NUL
RMDIR %MSD%
DEL %MSD%
CTTY CON
@ECHO
@ECHO            ERROR - %MSD% is an invalid drive or directory
@ECHO                    name. Please refer to the Demo and 
@ECHO                    Installation guide for more information.
@ECHO
@ECHO               *****  Installation ending on ERROR  *****
GOTO END

:DONE
ECHO
ECHO            The Synchronics Version 6.5 Multi-Site Demo has
ECHO            been installed in the %MSD% directory. Refer to
ECHO            the Demo and Installation Guide for information on
ECHO            connecting to the Satellite and running the Demo.
@REM
:END
