/*  The procedure created by this query will "explode" a Bill of Materials
to an arbitrary depth. It uses a "stack" in the form of a temporary table,
similar to stacks in other programming languages.  The current parent is
placed on the stack, the children of that parent are found and added to the
stack, and the parent is deleted. The procedure then tries to find the next
level of children down for every entry in the stack. This continues until
there are no more lower levels of children.

The output of this procedure is simply a printout of the parents followed
by all of their children, with each level of child indented. */



create procedure BOM (@current char(40)) 
as
set nocount on                     /* Turn off printout of rows processed */

declare @level int,                /* Create two temporary variables */
        @msg   char(40)

create table #stack (child char(20), level int)   /* Create the "stack" */

insert into #stack values (@current, 1)           /* The first entry in the
                                                  stack is the parameter
                                                  passed when procedure is
                                                  called. This is level 1. */

select @level = 1                  /* Select is used to set the initial value
                                   of a variable */

while @level > 0                   /* Stop the process once there are
                                   no more entries on the stack to find
                                   children for. */
begin

     if exists (select * from #stack
          where level = @level)         /*  Are there any more parents on
                                        the stack at the current level?
                                        If not, jump to the ELSE statement */

     begin

          select @current = MIN(child)
          from #stack
               where level = @level     /*  Find the one lowest parent on
                                        the stack at the current level.  */

          select @msg = SPACE(@level * 4)
               + @current               /* Fill the msg string
                                        with parent name, indented */
          print @msg

          delete from #stack
               where level = @level
               and child = @current     /* Remove the parent just printed
                                        from the stack */

          insert #stack
               select child, @level + 1
               from hierarchy
               where parent = @current  /* Insert new entries on the stack
                                        which are the children of the parent
                                        just printed. These become the new
                                        parents. */

          if @@rowcount > 0
               select @level=@level + 1   /* Were there any children selected
                                          by the last statement? If so,
                                          increment the @level variable
                                          by 1. */

     end

     else select @level = @level - 1     /* When there are no more parents
                                         on the stack at the current level,
                                         look back up one level. */

end
