#include <stdio.h>
#include <dos.h>


/* use CP=37A for lpt2: */
#define CP      0x3be

/* use DP=378 for lpt2: */
#define DP      0x3bc

/* use IP=379 for lpt2: */
#define IP      0x3bd

#define LA      0xe1
#define MA      0xe2
#define HA      0xe3
#define NOPA    0xe0
#define HI_NYB  0xe0
#define LO_NYB  0xe8

void readblock();
int blockmatch();


void main(void)
{

unsigned char seg;
unsigned char base[256], block[256];
int byte;
int k;
float megs;

printf("\n\t\tSIZE TEST\n");
printf("\t\t\tby The Silicon Valley Swappe Shoppe \n\n");

for (byte=0; byte<256; byte++) block[byte]=0;

/* start code */
  outportb (DP, 0);
  outportb (CP, HA);
  outportb (CP, NOPA);

    outportb (DP, 1);
    outportb (CP, MA);
    outportb (CP, NOPA);

readblock(base);

for (byte=0;byte < 255; byte++) {
     if ((base[byte] >= 0x20) && (base[byte] <=0x7f)) printf ("%c", base[byte]);
     if (((byte+1) % 32)==0) printf("\n");
     }

seg=0;

while (blockmatch (base, block) == 0) {
  seg++;
  outportb (DP, seg);
  outportb (CP, HA);
  outportb (CP, NOPA);
  readblock(block);
}
k=seg * 64;
megs = seg / 2.0;
printf ("\nCartridge appears to be %d kbytes (%1.1f Megabits)\n", k, megs);

}



void
readblock (block)
unsigned char *block;
{
int byte;
unsigned char tmp, hi_nyb, lo_nyb;

    for (byte=0; byte < 256 ; byte++) {
      outportb(DP, byte);
      outportb(CP, LA);

      outportb(CP, HI_NYB);
      tmp = inportb(IP);
      hi_nyb = (tmp ^ 0x80) & 0xf0;

      outportb(CP, LO_NYB);

      tmp= inport(IP);
      lo_nyb = (tmp ^ 0x80) & 0xf0;
      lo_nyb = lo_nyb >> 4;
      tmp=lo_nyb | hi_nyb;
      block[byte]=tmp;
    }
}

int
blockmatch(block1, block2)
unsigned char *block1, *block2;
{
int i;

for (i=0; i<256; i++)
  if (block1[i] != block2[i]) return (0);
return (1);
}

