/**********************************************************
 *
 *  CADmagic SpellCheck Version 2 for AutoCAD R12
 *  Copyright (c) 1992,93 by Haestad Methods, Inc.
 *
 *  CMSPELL.DCL
 *
 *  (c)    COPYRIGHT 1992,93 BY HAESTAD METHODS, INC.
 *********************************************************
 *---------*
 * DIALOGS *
 *---------*
 * spell_main : dialog
 * spell      : dialog
 * splogo     : dialog
 * version    : dialog
 * options    : dialog
 * userdict   : dialog
 * locate     : dialog
 * stats      : dialog
 * yesno_dlg  : dialog
 * info_dlg   : dialog
 * aboutbox   : dialog
 *---------*
 * BUTTONS *
 *---------*
 * yesno_button : column
 * yes_button   : retirement_button
 * no_button    : retirement_button
 * _ok_button   : retirement_button
 * quit_button  : retirement_button
 *
 */
/*********************************************************/
/*                                                       */
/* SPELL CHECKING DIALOG                                 */
/*                                                       */
/*********************************************************/
spell : dialog {
   label = "Spell Check";
   initial_focus = "skip word";
   /*********/
   : column {
      : text {
         key = "status";
         alignment = centered;
      }
   }
   /***********/
   : boxed_row {
      label = "Word not found:";
      : text {
         key = "sentence";
         fixed_width = true;
         width = 60;
      }
   }
   /*****/
   : row {
      fixed_width = true;
      width = 60;
      : column {
         fixed_width = true;
         width = 2.5;
      }
      : column {
         fixed_width = true;
         width = 8;
         : text {
            key = "original";
            value = "Change: ";
         }
      }
      : column {
         fixed_width = true;
         width = 25;
         : text {
            key = "misspelled";
            alignment = left;
         }
      }
      : column {
         fixed_width = true;
         width = 24;
      }
   }
   /*****/
   : row {
      : column {
         fixed_width = true;
         width = 36;
         : edit_box {
            return_value = "0010";
            key = "edit word";
            label = "To:";
            mnemonic = "T";
            fixed_width = true;
            alignment = right;
            width = 29;
         }
         : list_box {
            return_value = "0011";
            key = "recommended";
            label = "Recommended words";
            mnemonic = "R";
            fixed_width = true;
            fixed_height = true;
            width = 25;
            height = 7;
            alignment = right;
         }
         spacer;
      }
      /********/
      : column {
         fixed_width = true;
         width = 24;
         : row {
            : button {
               return_value = "0001";
               key = "change";
               label = "Change";
               mnemonic = "C";
               fixed_width = true;
               width = 12;
            }
            : button {
               return_value = "0002";
               key = "change all";
               label = "Change all";
               mnemonic = "n";
               fixed_width = true;
               width = 12;
            }
         }
         : row {
            : button {
               return_value = "0003";
               key = "skip word";
               label = "Skip word";
               mnemonic = "S";
               fixed_width = true;
               width = 12;
               is_default = true;
            }
            : button {
               return_value = "0004";
               key = "skip all";
               label = "Skip all";
               mnemonic = "k";
               fixed_width = true;
               width = 12;
            }
         }
         : row {
            : button {
               return_value = "0005";
               key = "add";
               label = "Add word";
               mnemonic = "A";
               fixed_width = true;
               width = 12;
            }
            : button {
               return_value = "0006";
               key = "undo";
               is_enabled = false;
               label = "Undo last";
               mnemonic = "U";
               fixed_width = true;
               width = 12;
            }
         }
         : row {
            : button {
               return_value = "0007";
               key = "retype";
               label = "Edit word";
               mnemonic = "E";
               fixed_width = true;
               width = 12;
            }
            : button {
               return_value = "0008";
               key = "options";
               label = "Options...";
               mnemonic = "O";
               fixed_width = true;
               width = 12;
            }
         }
         : row {
            : button {
               return_value = "0009";
               key = "locate";
               label = "Locate...";
               mnemonic = "L";
               fixed_width = true;
               width = 12;
            }
            quit_button;
         }
         : button {
            key = "help";
            label = "Help...";
            mnemonic = "H";
            fixed_width = true;
            width = 12;
            alignment = centered;
         }
      }
   }
   /*****/
   : row {
      : column {
         spacer;
         : text {
            value = "";
            key = "progress";
         }
         errtile;
      }
      : image_button {
         key = "about";
         return_value = "0012";
         color = dialog_background;
         alignment = right;
         fixed_width = true;
         fixed_height = true;
         aspect_ratio = 0.42;
         width = 12;
         is_tab_stop = false;
      }
   }
}
/*********************************************************/
/*                                                       */
/* MAIN SPELL DIALOG                                     */
/*                                                       */
/*********************************************************/
spell_main : dialog {
   : column {
      fixed_width = true;
      width = 30;
      initial_focus = "main_global";
      : image_button {
         return_value = "0004";
         alignment = centered;
         aspect_ratio = 2.5;
         color = dialog_background;
         key = "main_logo";
         fixed_height = true;
         fixed_width = true;
         height = 7;
         is_tab_stop = false;
      }
      : row {
         alignment = centered;
         children_alignment = centered;
         fixed_width = true;
         fixed_height = true;
         width = 40;
         height = 4;
         spacer;
         : button {
            return_value = "0001";
            key = "main_select";
            label = "Select <";
            mnemonic = "S";
            fixed_width = true;
            fixed_height = true;
            width = 13;
            height = 2;
         }
         : button {
            return_value = "0002";
            key = "main_global";
            is_default = true;
            label = "Select All";
            mnemonic = "A";
            fixed_width = true;
            fixed_height = true;
            width = 13;
            height = 2;
         }
         : button {
            return_value = "0003";
            key = "main_options";
            label = "Options...";
            mnemonic = "O";
            fixed_width = true;
            fixed_height = true;
            width = 13;
            height = 2;
         }
         spacer;
      }
      : row {
         alignment = centered;
         children_alignment = centered;
         fixed_width = true;
         width = 25;
         : button {
            return_value = "0004";
            key = "main_about";
            label = "About";
            mnemonic = "b";
            fixed_width = true;
            width = 12;
         }
         quit_button;
         : button {
            key = "help";
            label = "Help...";
            mnemonic = "H";
            fixed_width = true;
            width = 12;
         }
      }
      : spacer { height = 1; }
   }
}
/*********************************************************/
/*                                                       */
/* SPELL LOGO DIALOG                                     */
/*                                                       */
/*********************************************************/
splogo : dialog {
   : row {
      spacer;
      : image_button {
         alignment = centered;
         aspect_ratio = 2.5;
         color = dialog_background;
         key = "splogo";
         fixed_height = true;
         fixed_width = true;
         height = 7;
         is_tab_stop = false;
      }
      spacer;
   }
   : column {
      : text {
         alignment = centered;
         value = "";
         key = "version";
         width = 30;
      }
      : text {
         alignment = centered;
         value = "Type SPELL to run";
         width = 30;
      }
   }
   : spacer { height = 0.5; }
     ok_only;
   : spacer { height = 0.5; }
   : button {
      key = "copyright";
      is_tab_stop = false;
      label = "Copyright (c) 1992,93 Haestad Methods, Inc.";
   }
}
/*********************************************************/
/*                                                       */
/* VERSION DIALOG                                        */
/*                                                       */
/*********************************************************/
version : dialog {
   : row {
      spacer;
      : image_button {
         alignment = centered;
         aspect_ratio = 2.5;
         color = dialog_background;
         key = "splogo";
         fixed_height = true;
         fixed_width = true;
         height = 7;
         is_tab_stop = false;
      }
      spacer;
   }
   : column {
      : text {
         alignment = centered;
         value = "";
         key = "version";
         width = 30;
      }
   }
   : spacer { height = 0.5; }
     ok_only;
   : spacer { height = 0.5; }
   : button {
      key = "copyright";
      is_tab_stop = false;
      label = "Copyright (c) 1992,93 Haestad Methods, Inc.";
   }
}
/*********************************************************/
/*                                                       */
/* OPTIONS DIALOG                                        */
/*                                                       */
/*********************************************************/
options : dialog {
   label = "Spell Check Options";
   initial_focus = "accept";
   fixed_width = true;
   : row {
      : column {
         fixed_width = true;
         : boxed_row {
            label = "Scope";
            alignment = centered;
            fixed_height = true;
            fixed_width = true;
            height = 4;
            width = 30;
            : column {
               : toggle {
                  label = "Text";
                  key = "opt_text";
                  mnemonic = "T";
                  return_value = "0003";
               }
               : toggle {
                  label = "Dimensions";
                  key = "opt_dims";
                  mnemonic = "D";
                  return_value = "0003";
               }
               : toggle {
                  label = "Attributes";
                  key = "opt_attr";
                  mnemonic = "A";
                  return_value = "0003";
               }
            }
            : column {
               : toggle {
                  label = "Attdefs";
                  key = "opt_attd";
                  mnemonic = "f";
                  return_value = "0003";
               }
               : toggle {
                  label = "Block inserts";
                  key = "opt_blok";
                  mnemonic = "B";
                  return_value = "0003";
               }
               : toggle {
                  label = "XRefs";
                  key = "opt_xref";
                  mnemonic = "X";
                  return_value = "0003";
               }
            }
         } //box row
         : boxed_row {
            label = "Advanced Options";
            alignment = centered;
            fixed_width = true;
            width = 30;
            : column {
               : toggle {
                  label = "Display Logo at load time";
                  key = "opt_logo";
                  mnemonic = "L";
                  return_value = "0003";
               }
               : toggle {
                  label = "Redraw on completion";
                  key = "opt_redraw";
                  mnemonic = "R";
                  return_value = "0003";
               }
               : toggle {
                  label = "Return to initial View";
                  key = "opt_view";
                  mnemonic = "V";
                  return_value = "0003";
               }
               : toggle {
                  label = "Ignore words with numbers";
                  key = "opt_numbers";
                  mnemonic = "I";
                  return_value = "0003";
               }
            }
         }//box row
         : spacer { height = 0.5; }
      } //column
      : spacer { width = 0.5; }
      /***************************************/
      : column {
         fixed_width = true;
         width = 25;
         spacer;
         : column {
            fixed_height = true;
            : button {
               label = "Restore factory defaults";
               key = "opt_restore";
               mnemonic = "e";
               return_value = "0002";
               alignment = centered;
            }
            : button {
               label = "User dictionary...";
               key = "opt_udict";
               mnemonic = "U";
               return_value = "0001";
               alignment = centered;
            }
            : boxed_column {
               label = "Current user dictionary:";
               : text {
                  key = "opt_dictname";
                  fixed_width = true;
                  width = 25;
               }
            }
         }
         spacer;
      }
   } //row
   /***************************************/
   : spacer { height = 0.5; }
   : row {
      : column {
         : toggle {
            label = "Save current settings";
            key = "save options";
            mnemonic = "S";
            fixed_width = true;
            width = 24;
            alignment = centered;
         }
         ok_cancel_help;
      }
   }
   : spacer { height = 0.5; }
}
/*********************************************************/
/*                                                       */
/* USERDICT DIALOG                                       */
/*                                                       */
/*********************************************************/
userdict : dialog {
   label = "User Dictionary Maintenance";
   fixed_width = true;
   width = 50;
   : column {
      fixed_width = true;
      alignment = centered;
      : spacer { height = 0.3; }
      : text {
         label = "User dictionary:";
      }
      : edit_box {
         key = "udict_fname";
         fixed_width = true;
         width = 45;
      }
      : button {
         key = "udict_select";
         label = "Select file...";
         mnemonic = "S";
         fixed_width = true;
         width = 19;
         alignment = centered;
      }
   }
   : spacer { height = 0.3; }
   : image {
      key = "line";
      color = dialog_foreground;
      height = 0.2;
      width = 45;
   }
   : row {
      fixed_width = true;
      alignment = centered;
      : column {
         : row {
            : text {
               label = "User words:";
            }
         }
         : row {
            fixed_width = true;
            : edit_box {
               key = "udict_edit";
               fixed_width = true;
               width = 25;
            }
            : column {
               fixed_width = true;
               width = 20;
               : button {
                  key = "udict_add";
                  label = "Add word";
                  mnemonic = "A";
                  alignment = centered;
               }
            }
         }
         : row {
            fixed_width = true;
            : list_box {
               key = "udict_list";
               fixed_width = true;
               width = 25;
               fixed_height = true;
               height = 5;
            }
            : column {
               alignment = top;
               fixed_height = true;
               fixed_width = true;
               width = 20;
               : button {
                  key = "udict_remove";
                  label = "Remove word";
                  mnemonic = "R";
               }
               : button {
                  key = "udict_undo";
                  label = "Undo last";
                  is_enabled = false;
                  mnemonic = "U";
               }
            }
         }
      }
   }
   ok_cancel_help;
   errtile;
}
/*********************************************************/
/*                                                       */
/* LOCATE DIALOG                                         */
/*                                                       */
/*********************************************************/
locate : dialog {
   key = "locate";
   label = "LOCATE";
   initial_focus = "restore";
   : column {
      : button {
         alignment = centered;
         alignment = centered;
         key = "up";
         return_value = "0003";
         label = "^";
         fixed_width = true;
         width = 4;
      }
      : row {
         fixed_width = true;
         alignment = centered;
         : button {
            key = "left";
            return_value = "0001";
            label = "<-";
            fixed_width = true;
            width = 3;
         }
         : button {
            key = "in";
            return_value = "0005";
            label = "In";
            mnemonic = "I";
            fixed_width = true;
            width = 3;
         }
         : button {
            key = "out";
            return_value = "0006";
            label = "Out";
            mnemonic = "O";
            fixed_width = true;
            width = 3;
         }
         : button {
            alignment = centered;
            key = "right";
            return_value = "0002";
            label = "->";
            fixed_width = true;
            width = 3;
         }
      } //row
      : button {
         key = "down";
         return_value = "0004";
         label = "v";
         fixed_width = true;
         width = 4;
         alignment = centered;
      }
   }//column
   : spacer { height = 0.3; }
   : row {
      alignment = centered;
      : button {
         key = "flash";
         return_value = "0007";
         label = "Flash";
         mnemonic = "F";
         fixed_width = true;
         width = 8;
      }
      _ok_button;
      : button {
         key = "restore";
         return_value = "0008";
         label = "Restore";
         mnemonic = "R";
         fixed_width = true;
         is_default = true;
      }
   }
   : spacer { height = 0.2; }
}
/*********************************************************/
/*                                                       */
/* STATS DIALOG                                          */
/*                                                       */
/*********************************************************/
stats : dialog {
   label = "Spell check completed";
   : row {
      fixed_height = true;
      height = 5;
      : image {
         key = "info";
         color = dialog_background;
         alignment = centered;
         aspect_ratio = 1.0;
         fixed_width = true;
         fixed_height = true;
         width = 6;
      }
      : boxed_row {
         label = "Statistics";
         : column {
            fixed_width = true;
            width = 21;
            : text {
               alignment = right;
               label = "  Spell checked words:";
            }
            : text {
               alignment = right;
               label = "     Entities checked:";
            }
            : text {
               alignment = right;
               label = "      Corrected words:";
            }
            : text {
               alignment = right;
               label = "        Skipped words:";
            }
            : text {
               alignment = right;
               label = "  Added to dictionary:";
            }
         }
         : column {
            fixed_width = true;
            width = 10;
            : text {
               alignment = left;
               key = "wordcount";
            }
            : text {
               alignment = left;
               key = "entcount";
            }
            : text {
               alignment = left;
               key = "replaced";
            }
            : text {
               alignment = left;
               key = "skipped";
            }
            : text {
               alignment = left;
               key = "added";
            }
         }
      }
      : spacer { width = 6; }
   }
   : spacer { height = 0.5; }
   : row {
      fixed_width = true;
      alignment = centered;
        ok_only;
      : button {
         alignment = centered;
         key = "stats_undo";
         label = "Undo last";
         mnemonic = "U";
         fixed_width = true;
         width = 12;
      }
      help_button;
   }
   errtile;
}
/*********************************************************/
/*                                                       */
/* YES/NO DIALOG                                         */
/*                                                       */
/*********************************************************/
yesno_dlg : dialog {
   : row {
      fixed_height = true;
      height = 5;
      : column {
         fixed_height = true;
         : image {
            key = "image";
            color = dialog_background;
            alignment = centered;
            aspect_ratio = 1.0;
            fixed_width = true;
            fixed_height = true;
            width = 6;
         }
      }
      : column {
         fixed_height = true;
         fixed_width = true;
         width = 30;
         : text {
            key = "message1";
            alignment = centered;
         }
         : text {
            key = "message2";
            alignment = centered;
         }
      }
      : spacer { width = 5; }
   }
     yesno_button;
   : spacer { height = 0.5; }
}
/*********************************************************/
/*                                                       */
/* INFO DIALOG                                           */
/*                                                       */
/*********************************************************/
info_dlg : dialog {
   : row {
      fixed_height = true;
      height = 5;
      fixed_width = true;
      width = 45;
      : image {
         key = "info_image";
         color = dialog_background;
         alignment = centered;
         aspect_ratio = 1.0;
         fixed_width  = true;
         fixed_height = true;
         width = 5;
      }
      : column {
         fixed_width = true;
         width = 40;
         spacer;
         : text {
            key = "info_msg1";
            alignment = centered;
         }
         : text {
            key = "info_msg2";
            alignment = centered;
         }
         spacer;
      }
   }
   : spacer { height = 0.5; }
     ok_only;
   : spacer { height = 0.5; }
}
/*********************************************************/
/*                                                       */
/* ABOUTBOX DIALOG                                       */
/*                                                       */
/*********************************************************/
aboutbox : dialog {
   label = "About";
   fixed_width = true;
   : row {
      : image {
         key = "about_logo";
         color = dialog_background;
         fixed_width = true;
         fixed_height = true;
         aspect_ratio = 0.42;
         width = 12;
      }
      : column {
         fixed_height = true;
         : text {
            key = "about_line1";
            label = "CADmagic SpellCheck version 2";
         }
         : text {
            key = "about_line2";
            label = "Written for AutoCAD Release 12";
         }
         : text {
            key = "about_line3";
            label = "Copyright (c) 1992,93 by Haestad Methods, Inc.";
         }
      }
   }
   : list_box {
      key = "about_text";
      fixed_width = true;
      width = 65;
   }
   : row {
      spacer;
      : button {
         alignment = centered;
         key = "about_order";
         label = "Print order form...";
         fixed_width = true;
      }
      : radio_row {
         fixed_width = true;
         : radio_button {
            key = "lpt1";
            label = "LPT1";
            mnemonic = "1";
         }
         : radio_button {
            key = "lpt2";
            label = "LPT2";
            mnemonic = "2";
         }
         : radio_button {
            key = "lpt3";
            label = "LPT3";
            mnemonic = "3";
         }
         : radio_button {
            key = "lpt4";
            label = "LPT4";
            mnemonic = "4";
         }
      }
   }
   spacer;
   ok_only;
   errtile;
}
/************************************/
/*                                  */
/* BUTTONS                          */
/*                                  */
/************************************/
yesno_button : column {
   : row {
       alignment = centered;
       fixed_width = true;
       yes_button;
       : spacer { width = 4; }
       no_button;
   }
}
/************************************/
yes_button : retirement_button {
   label = "  Yes  ";
   key = "accept";
   is_default = true;
   mnemonic = "Y";
}
/************************************/
no_button : retirement_button {
   label = "  No  ";
   key = "cancel";
   is_cancel = true;
   mnemonic = "N";
}
/**********************************/
_ok_button : retirement_button {
   label = " OK ";
   key = "accept";
   return_value = "0000";
   mnemonic = "K";
   is_cancel = true;
   fixed_width = true;
   width = 3;
}
/**********************************/
quit_button : retirement_button {
   return_value = "0000";
   key = "quit";
   label = "Quit";
   mnemonic = "Q";
   is_cancel = true;
   fixed_width = true;
   width = 12;
}
/**************************************************************/
/* END OF CMSPELL.DCL                                         */
/**************************************************************/
