#*      DBP.MAK
#*
#* MIDAS Debug module player makefile
#*
#* Copyright 1994 Petteri Kangaslampi and Jarno Paananen
#*
#* This file is part of the MIDAS Sound System, and may only be
#* used, modified and distributed under the terms of the MIDAS
#* Sound System license, LICENSE.TXT. By continuing to use,
#* modify or distribute this file you indicate that you have
#* read the license and understand and accept it fully.
#*


# Compiler directories:

BCDIR = c:\bc
LIBDIR = $(BCDIR)\lib


# Compilers and options:

CC = bcc
CCOPTS = -c -3 -G -v -ml -l-v-c -I$(BCDIR)\include -DDEBUG
ASM = tasm
ASMOPTS = -UT310 -ml -zi -m9 -dDEBUG
LINK = tlink
LINKOPTS = -c -v


# MIDAS Sound System object files:

MIDASOBJS = mglobals.obj errors.obj ems.obj mod.obj modload.obj s3m.obj s3mload.obj timer.obj gus.obj pas.obj wss.obj sb.obj nsnd.obj dsm.obj dma.obj mem.obj


dbp.exe : dbp.obj $(MIDASOBJS)
        $(LINK) $(LINKOPTS) $(LIBDIR)\c0l.obj dbp.obj @dbpobjs, dbp, dbp, $(LIBDIR)\cl.lib

dbp.obj : dbp.c midas.h
        $(CC) $(CCOPTS) dbp.c


mglobals.obj : mglobals.c
        $(CC) $(CCOPTS) mglobals.c

errors.obj : errors.c errors.h
        $(CC) $(CCOPTS) errors.c

midas.obj : midas.c midas.h
        $(CC) $(CCOPTS) midas.c

s3mload.obj : s3mload.c midas.h
        $(CC) $(CCOPTS) s3mload.c

modload.obj : modload.c midas.h
        $(CC) $(CCOPTS) modload.c

mem.obj : mem.c mem.h errors.h
        $(CC) $(CCOPTS) mem.c


s3m.obj : s3m.asm lang.inc errors.inc mglobals.inc s3m.inc mplayer.inc sdevice.inc ems.inc timer.inc
        $(ASM) $(ASMOPTS) s3m.asm

mod.obj : mod.asm lang.inc errors.inc mglobals.inc mod.inc mplayer.inc sdevice.inc ems.inc timer.inc mglobals.inc
        $(ASM) $(ASMOPTS) mod.asm

gus.obj : gus.asm lang.inc mglobals.inc sdevice.inc mem.inc mglobals.inc
        $(ASM) $(ASMOPTS) gus.asm

sb.obj : sb.asm lang.inc errors.inc sdevice.inc dsm.inc dma.inc
        $(ASM) $(ASMOPTS) sb.asm

wss.obj : wss.asm lang.inc errors.inc sdevice.inc dsm.inc dma.inc
        $(ASM) $(ASMOPTS) wss.asm

pas.obj : pas.asm pas.inc lang.inc errors.inc sdevice.inc dsm.inc dma.inc
        $(ASM) $(ASMOPTS) pas.asm

nsnd.obj : nsnd.asm lang.inc sdevice.inc
	$(ASM) $(ASMOPTS) nsnd.asm

dma.obj : dma.asm lang.inc errors.inc dma.inc mem.inc
	$(ASM) $(ASMOPTS) dma.asm

dsm.obj : dsm.asm lang.inc errors.inc mglobals.inc dsm.inc dma.inc mem.inc ems.inc sdevice.inc
	$(ASM) $(ASMOPTS) dsm.asm

timer.obj : timer.asm errors.inc mglobals.inc lang.inc timer.inc ems.inc dma.inc dsm.inc sdevice.inc
        $(ASM) $(ASMOPTS) timer.asm

ems.obj : ems.asm lang.inc errors.inc ems.inc mem.inc
	$(ASM) $(ASMOPTS) ems.asm

vu.obj : vu.asm lang.inc errors.inc vu.inc mem.inc sdevice.inc
        $(ASM) $(ASMOPTS) vu.asm



midas.h : errors.h mglobals.h mem.h sdevice.h mplayer.h s3m.h mod.h timer.h ems.h dma.h dsm.h vu.h
        touch midas.h

midas.inc : lang.inc errors.inc mglobals.inc mem.inc sdevice.inc mplayer.inc s3m.inc mod.inc timer.inc ems.inc dma.inc dsm.inc vu.inc
        touch midas.inc
