#	Calculate the total space used by specified files or directories
#	Copyright (c) 1992 by Hamilton Laboratories.  All rights reserved.
		
proc sizeof(files)
	#	Method is as follows:
	#	1. Get a long listing of all the files of interest, walking thru any
	#		subdirectories that may have been specified.
	#	2. Cut out the field 6, the column showing the space used.  (Note
	#		that the space is taken delimiter and that repeated spaces are
	#		ignored.)
	#	3. Paste this series of numbers back on the command line with backquotes
	#		and globally substitute +'s for the spaces between each pair of
	#		numbers.
	#	4. Run this constructed statement back thru the parser and execute
	#		it with the eval statement.
	eval return `ls -Lw! $files | cut -f6 -rd^ `:gS/ /+/
end

sizeof $argv
