/***************************************************************************/
/*																									*/
/*																									*/
/*			Dump the current environmentals as setenv statements.					*/
/*	Copyright (c) 1989-1992 by Hamilton Laboratories.  All rights reserved.	*/
/*																									*/
/*																									*/
/***************************************************************************/
		
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*	This little utility will dump out your environmental variables in a
	form that can be executed in a login.csh file.  It looks for any
	characters that need enclosing single quotes and uses the individual
	escapesym character (assumed to be '^') to escape any that require
	more than just single quotes.
	
	(escapesym chars, assumed to be '^', are not further quoted; we assume
	if this appears, it's probably meant to be a quote of the next character.)

	When it writes out the PATH variable, it inserts ".;", representing
	the current directory to the start of the string if it's not already
	there.  This is a convenience in converting from cmd.exe's convention
	of always trying the current directory first to csh.exe's of trying
	the current directory only if you specify it.  (You can conditionally
	compile-out this option by #defining TruePATH.)

	*/

char chars_needing_quotes[] = "!\n\r'\"` &|;<>()*?{}[]~$";

void cdecl main ( int argc, char *argv[], char *envp[] )
		{
		register char *e;
		int i;
		for (i = 0;  envp[i]; i++)
			{
			for (e = envp[i];  *e && !strchr(chars_needing_quotes, *e);  e++)
				;
			if (*e)
				{
				/*	Enclose the value in quotes. */
				e = strchr(envp[i], '=');
				*e = '\0';
				printf ("setenv %s='", envp[i]);

#				ifndef TruePATH
					if (strcmp(envp[i], "PATH") == 0 &&
							(e[1] != '.' || e[2] != ';'))
						{
						/*	PATH variable doesn't already start with ".;" */
						putchar('.');
						putchar(';');
						}
#				endif

				while (*++e)
					switch (*e)
						{
						case '!':
						case '"':
						case '\'':
						case '`':
							putchar('^');
							putchar(*e);
							break;
						case '\n':
							putchar('^');
							putchar('n');
							break;
						case '\r':
							putchar('^');
							putchar('r');
							break;
						default:
							putchar(*e);
						}
				fputs("'\n", stdout);
				}
			else
				/*	Ignore the possibility of a PATH variable that didn't have at
					least one semicolon. */
				printf ("setenv %s\n", envp[i]);
			}
		exit(0);
		}
