#	Customize the screen colors.
#	Copyright (c) 1991 by Hamilton Laboratories.  All rights reserved.

#	This script shows you how to customize the screen colors used by
#	Hamilton C shell and its utilities.  You might just use a script like
#	this for changing your colors, perhaps calling it from your login.csh
#	or you might embed these color settings directly into your login.csh
#	or (after rewriting them as SET statements) into your config.sys.

#	These are the environmental variables controlling screen colors:

#		Name				Use												Default

#		ADDITIONS		Lines added found by diff.					Bright Green
#		COLORS			Normal screen colors							White on Black
#		DELETIONS		Lines deleted found by diff.				Bright Red
#		DIRECTORIES		Directories listed by ls.					Bright
#		DUPLICATES		When filename completion matches			Green
#							more than one name.
#		FOREIGNFILES	Filetypes that have no counterpart		Bright Red
#							on OS/2.
#		HIGHLIGHT		Current disk or directory.					Bright
#		MATCHFAIL		When filename or command completion		Bright Red
#							doesn't match anything.
#		MOREEOF			End or Top of File in more.				Green
#		MOREERROR		Unrecognizable command to more.			Bright Yellow
#		MOREFILLIN		User response to more prompt.				White
#		MOREPROMPT		Prompt line in more.							Green
#		MORETOPMEM		Top of Memory message from more.			Bright Yellow
#		SYSTEMDIRS  	Directories with the System bit on.		Bright Green
#		SYSTEMFILES		Files with the System bit on.				Green

#	The colors available in the C shell are black, red, green, yellow, blue,
#	magenta (or blue red), cyan (or blue green) and white.  Foreground colors
#	may also be bright, dim, blink or reverse.  The keyword "on" introduces
#	background colors.  All the names of the colors along with the keywords
#	bright, dim, blink, reverse and on may be in upper, lower or mixed case.
#	The names of the environmental variables must be all in upper case.

#	(Blink causes true blinking only full-screen; in a text window, it
#	just makes the background brighter.)

# 	If a foreground or background color is left unspecified, that plane
#	is considered transparent and inherits the color underneath it.

#	Here is a sample color scheme that's a little more colorful than the
#	normal defaults:

setenv	COLORS			=	white on blue
setenv	DELETIONS		=	bright white on red
setenv	ADDITIONS		=	bright white on green
setenv	MOREPROMPT		=	red on white
setenv	MOREFILLIN		=	black
setenv	MOREERROR		=	bright white on red
