/* filename: VDPOPINI.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <vidpop.h>
  
#define color 0x8000
#define mono 0x0000
  
void VidpopExitProc(void);
  
int  GetMenuResponse    = TRUE;
int  ClearTopLine               = TRUE;
void (* UserGetProc)(GetRecord * ptr) = NULL;
int  ResetBackground    = TRUE;
int  SuppressDisplay    = FALSE;
int  AutoSaveMode               = FALSE;
int  MenuEscapeEnable  = TRUE;
char _tzfar MenuString[STRSIZ] = "";
int  MenuChoice  = 0;
char MenuChar    = '\0';
int  MenuSeed    = 1;
char MenuKey                    = '\0';
int  IgnoreNumLock = FALSE;
int  ExitMenu  = FALSE; // allows exiting menu via FKEY procedure
int  EnableLeftRightMenuExit = TRUE;
int  EnableUpDownMenuExit    = TRUE;
int  VgaBrightBackEnabled    = FALSE;
  
unsigned  BaseSeg  = 0xB000, VideoOffset = 0;
unsigned  VidpopPageSize  = 4000;
/*
Normal page sizes:
25 lines = 4000;  chars per screen CGA/MDA
43 lines = 6880;  EGA 43 line mode
50 lines = 8000;  VGA 50 line mode
*/
SwitchType LineSwitchMode  = Automatic;
  
int AddShadow = FALSE;
char _tzfar FKeyExit[41] = "";
char FirstRow  = 2;
int  InhibitSnow = TRUE;
unsigned char MaxCols = 80;
unsigned char MaxRows = 25;
void  (* MenuHelpProc)(void) = NULL;
void  (* MenuFKeyProc)(void) = NULL;
char  MenuTimeOutValue = 0;
unsigned char OneLineLength = 160; // One DISPLAY line length = MaxCols * 2
int TopStatusLine = TRUE;
int UseSnowInhibition = TRUE;
  
void    *ScreenAddress = NULL;  //      Base address of video memory
unsigned UsersCursor = 0;
void    *SaveExit = NULL;
int     ScreenFound = 0;
  
int UpCase(char c); //handles umlaut characters
void brightbg(int onoff, char cardtype);
  
MenuPtr  MenuStackPtr    = NULL;
WindowPtr WindowStackPtr = NULL;
void  (* ClockPtr)(void) = NULL;
char  *ColorMap  = NULL;
int   BW         = FALSE;
int   TopView    = FALSE;
char  MenuBarAttr= 112;
  
int   Shift      = 0; /*  Either 0 or OneLineLength depending on whether
using top status line.  This is different from how it was being used!
It is now the Amount To Shift, instead of a multiplier used to calculate the
shift. ALSO, it can now be negative!! */
  
unsigned char NewRow = 255;
unsigned char NewCol = 255;
  
library_array_record *LibraryArray[MaxScreenLibraries] = { NULL }; // must be NULLs on startup
unsigned New_Vo   = 0;
int MovingBarMenu = 0;
int CallUserProc  = 0;
char ScreenType   = 0;
  
void TZVidpopInit(void)
{
  struct REGPACK cpu;
  
  // initialize InhibitSnow and ScreenAddress
  if (VideoMode() == 7)  {
    ScreenAddress =(void *) MK_FP(0xB000,0x0); // Mono
    VideoOffset = mono;
  }
  else {
    ScreenAddress = (void *) MK_FP(0xB800,0x0); // Color
    VideoOffset = color;
  }
  InhibitSnow = (VideoCard() >> 8) == 3;
  UsersCursor = * (unsigned*) MK_FP(0,0x460);
  
  // check for TopView or DesqView
  // get address of screen buffer to write to
  memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility
  cpu.r_ax  = 0xfe00; // TopView function
  cpu.r_es  = BaseSeg; // BASESEG value,  $B000
  cpu.r_di  = VideoOffset; // start with a known video buffer address
  intr(0x10, &cpu); // get the topview buffer
  BaseSeg = cpu.r_es ; // new baseseg if TopView,DesqView, or Windows present
  New_Vo = cpu.r_di ;  //  new offset
  if ((BaseSeg != 0xB000) || (New_Vo != VideoOffset)) {
    BaseOfScreen = BaseSeg;
    InhibitSnow = FALSE;
    TopView = TRUE;
    VideoOffset = New_Vo;
  }
  // check for extended keyboards
  IgnoreNumLock = ((* (char*) MK_FP(0x40,0x96) & 0x10) != 0);
  
  atexit(VidpopExitProc);
}
