/* filename: TZFONT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <share.h>
#include <io.h>
#include <vidpop.h>

#define Empty_Font_Stack "Empty Font Stack"

// for PushFont/PopFont
typedef struct FontRecord {
  struct FontRecord *PriorFont;
  void              *SavedFont;
  BOOL               Plane;
} FontRecord, *FontPtr;

static FontPtr  FontStackPtr  = NULL;
static unsigned hiVideoCard = 0;
static FontInitialized = FALSE;

static BOOL      FontCapable;    //  set by unit initialization code
static unsigned  BytesPerChar;   //  set by GetFontInfo()
static char     *CurrentFontPtr; //  set by GetFontInfo()

static void GetCharSet(void *FontSet, unsigned Size)
{
  struct REGPACK cpu;
  void  *charSet;

#ifdef _MSC_VER
  unsigned regAX, regBX, regCX, regES, regBP;

  regAX = 0x1130;
  if (MaxAvailRows() == 25) {
    if (hiVideoCard == 4U)
      regBX = 0x0002; // for ega's, otherwise this would be 6
    else
      if (hiVideoCard == 5U) // 5= "alternate 9x14 pointer, 6= "8x14 pointer", 
        regBX = 0x0006;      //    and 7= "replacement font pointer"
  }
  else
    regBX = 0x0003;     // 43/50 line mode so return ROM 8x8 pointer

  _asm {
    mov AX, regAX
    mov BX, regBX
    int 0x10
    mov regCX, CX
    mov regES, ES
    mov regBP, BP
  }
  BytesPerChar = regCX;
  if (BytesPerChar < 14)
    BytesPerChar = 14;
  charSet = MK_FP(regES, regBP);
#else
  memset(&cpu, 0, sizeof(cpu));
  cpu.r_ax = 0x1130;
  if (MaxAvailRows() == 25) {
    if (hiVideoCard == 4U)
      cpu.r_bx = 2;  // for ega's, otherwise this would be 6
    else
      if (hiVideoCard == 5U)
        cpu.r_bx = 6; // 5= "alternate 9 x 14 pointer, 6= " 8 x 14 pointer",
                      //    and 7= "replacement font pointer"
  }
  else
    cpu.r_bx = 3;   // 43/50 line mode so return ROM 8x8 pointer
  intr(0x10,&cpu);
  BytesPerChar = cpu.r_cx;
  if (BytesPerChar < 14)
    BytesPerChar = 14;
  charSet = MK_FP(cpu.r_es, cpu.r_bp);
#endif

  memset(FontSet, 0, Size);
  memcpy(FontSet,charSet, 256 * BytesPerChar);
  if (hiVideoCard == 5U) {
    memset(&cpu, 0, sizeof(cpu));
    cpu.r_ax = 0x1000;
    cpu.r_bx = 0x0C10;
    intr(0x10,&cpu);
  }
}

#ifdef _MSC_VER

static void GetFontInfo(void)
{
/* some people claim that this does not in MSC7.0...
   so comment it out for a while, check it later
  unsigned regAX, regBX, regCX, regES, regBP;

  regAX = 0x1130;
  regBX = (hiVideoCard == 4U) ? 0x0002 : 0x0006;
  _asm {
    mov AX, regAX
    mov BX, regBX
    int 0x10
    mov regCX, CX
    mov regES, ES
    mov regBP, BP
  }
  BytesPerChar = regCX;
  CurrentFontPtr = (char *) MK_FP(regES, regBP);
*/
  return;
}
#else

static void GetFontInfo(void)
{
  struct REGPACK cpu;

  memset(&cpu, 0, sizeof(cpu));
  cpu.r_ax = 0x1130;
  cpu.r_bx = (hiVideoCard == 4U) ? 2 : 6;
  intr(0x10,&cpu);
  BytesPerChar = cpu.r_cx;
  CurrentFontPtr = (char *) MK_FP(cpu.r_es, cpu.r_bp);
}
#endif

static void InitFont(void)
{
  if (FontInitialized) return;
  if (!CheckRegisteredUnits("InitFont", REGTZCOMMON+REGTZVIDPOP))
    return;
  hiVideoCard = VideoCard() >> 8;
  FontCapable = ((hiVideoCard == 4) || (hiVideoCard == 5)); // must have EGA or VGA for fonts to work
  GetFontInfo();
  FontInitialized = TRUE;
}


void  GetFont(void *FontPtr, unsigned StartingChar, unsigned Count)
{
  typedef unsigned char CharData[32];
  CharData *FPtr;
  char     *p;
  unsigned  i;

  InitFont();

  FPtr = (CharData *) FontPtr;
  p = CurrentFontPtr + StartingChar*BytesPerChar;
  for (i = 0; i < Count; i++) {
    memcpy(FPtr,p,BytesPerChar);
    p += BytesPerChar;
    ++FPtr;
  }
}

int  LoadFontMem(void *FontID, BOOL Primary)
{
  unsigned Offset, i;
  unsigned char StartingChar, CharsInGroup;
  unsigned char ThisChar[32];
  char *p;

  InitFont();

  if (FontID == NULL)
        return 1;   //  pointer not specified
  if (!FontCapable)
        return 255;   //  video card does not support fonts
  p = (char *)FontID + 16; // p points to offset to start of data
  Offset = *(unsigned *)p;
  p = (char *)FontID + 38; // p points to BytesPerChar
  BytesPerChar = *p;
  p = (char *)FontID + Offset; // p points to start of data
  StartingChar = *(unsigned char *)p;
  ++p;
  CharsInGroup = *(unsigned char *)p;
  if (CharsInGroup * BytesPerChar > 256 * 32)
        return 254;   //  fonts exceed video memory
  ++p;
  memset(ThisChar, 0, 32);
  for (i = 0; i <= CharsInGroup; i++) {
    memcpy(ThisChar, p, BytesPerChar);
    PutFont(ThisChar, StartingChar + i, 1, Primary);
    p += BytesPerChar;
  }
  return 0;
}

int LoadFont(const char *fontfilename, BOOL Primary)
{
  int  f; // file handle
  char fontfname[80];
  char  Signature[17];
  unsigned Offset, i;
  unsigned char MajorVersion, MinorVersion;
  unsigned char StartingChar, CharsInGroup;
  unsigned char ThisChar[32];

  InitFont();

  if (*Trim(fontfilename) == 0)
    return 1;   //  file not specified
  if (!FontCapable)
    return 255;   //  video card does not support fonts
  strncpy(fontfname, ReplaceExt(fontfilename,"TZF"), 80);
  *(fontfname + 79) = 0;
  _doserrno = 0;
  f = sopen(fontfname,O_RDONLY | O_BINARY, SH_DENYRW, S_IREAD);
  if (f == -1)
    return _doserrno;
  else {
    Signature[16] = 0;
    if (read(f, Signature, 16) != 16)
      goto bailout;
    if (read(f, &Offset, 2) != 2)
      goto bailout;
    if (read(f, &MajorVersion,1) != 1)
      goto bailout;
    if (read(f, &MinorVersion,1) != 1)
      goto bailout;
    lseek(f, Offset - 33, SEEK_SET);     //  get BytesPerCharacter
    if (read(f, &BytesPerChar, 1) != 1)
      goto bailout;
    lseek(f, Offset, SEEK_SET);         //  go right to the data
    if (read(f, &StartingChar, 1) != 1)
      goto bailout;
    if (read(f, &CharsInGroup, 1) != 1)
      goto bailout;
    memset(ThisChar, 0, 32);
    for (i = 0; i <= CharsInGroup; i++) {
      if (read(f, ThisChar, BytesPerChar) != (int) BytesPerChar)
        break;
      PutFont(ThisChar, StartingChar + i, 1, Primary);
    }
bailout:
    close(f);
    return _doserrno;
  }
}

void  PushFont(BOOL Primary)
{
  FontPtr  ThisFont;

  InitFont();

  ThisFont = (FontPtr) malloc(sizeof(FontRecord));
  if (!ThisFont) {
    SetError(217, 1, " [PushFont]");
    return;
  }
  memset(ThisFont, 0, sizeof(FontRecord));

  ThisFont->SavedFont = malloc(256 * 32);
  if (!ThisFont->SavedFont) {
    free(ThisFont);
    SetError(217, 1, " [PushFont]");
    return;
  }
  GetCharSet(ThisFont->SavedFont,256 * 32);
  ThisFont->PriorFont = FontStackPtr;
  ThisFont->Plane = Primary;
  FontStackPtr = ThisFont;
}

void  PopFont(void)
{
  void *Prior, *p;
  int i;
  
  InitFont();

  if (FontStackPtr == NULL) {
    SetError(228, 2, Empty_Font_Stack, " [PopFont]");
    return;
  }

  p = FontStackPtr->SavedFont;
  for (i = 0; i <= 255; i++) {
    PutFont(p, i, 1, FontStackPtr->Plane);
    p = (char *) p + BytesPerChar; //  Advance to next character
  }
  Prior = FontStackPtr->PriorFont;
  free(FontStackPtr->SavedFont);
  free(FontStackPtr);
  FontStackPtr = Prior;
}

