/* filename: SWITCH.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
// handles switching video modes for different size saywhat screens
// table of possibilities related to swithing line modes
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#ifdef _MSC_VER
#include <graph.h>
#else
#include <graphics.h>
#endif
#include <vidpop.h>
  
typedef struct TableType {
  int Over25;
  char CurrentMode;
  char CardCapability;
  char CreateMode;
  char result;
} TableType;
  
static TableType _tzfar Table[35] = {
  {FALSE,25,43,25,0},  {FALSE,25,43,43,43}, {FALSE,25,43,50,43},
  {FALSE,25,43,66,43}, {FALSE,25,50,25,0},  {FALSE,25,50,43,50},
  {FALSE,25,50,50,50}, {FALSE,25,50,66,50}, {FALSE,43,43,25,25},
  {FALSE,43,43,43,0},  {FALSE,43,43,50,0},  {FALSE,43,43,66,0},
  {FALSE,43,50,25,25}, {FALSE,43,50,43,0},  {FALSE,43,50,50,50},
  {FALSE,43,50,66,50}, {FALSE,50,50,25,25}, {FALSE,50,50,43,0},
  {FALSE,50,50,50,0},  {FALSE,50,50,66,0},  {TRUE,25,43,43,43},
  {TRUE,25,43,50,43},  {TRUE,25,43,66,43},  {TRUE,25,50,43,50},
  {TRUE,25,50,50,50},  {TRUE,25,50,66,50},  {TRUE,43,43,43,0},
  {TRUE,43,43,50,0},   {TRUE,43,43,66,0},   {TRUE,43,50,43,0},
  {TRUE,43,50,50,50},  {TRUE,43,50,66,50},  {TRUE,50,50,43,0},
  {TRUE,50,50,50,0},   {TRUE,50,50,66,0}
};
  
static char CardCap(void)
{
  char    lines;
  
  switch (VideoCard() >> 8) {
    case 1:
    case 2:  // monochrome..cga
    case 3: lines = 25; break;
    case 4: lines = 43; break; // ega
    case 5:
    case 6: lines = 50; break; // vga
    default:lines = 25; // unknown
  }
  return lines;
}
  
static char SwitchTableResult(char ScreenRows, char CreateMode)
{
  int i;
  
  for (i = 0; i < 35; i++)  {
    if ((Table[i].Over25 == (ScreenRows > 25)) &&
      (Table[i].CurrentMode == (char) MaxAvailRows()) &&
      (Table[i].CardCapability == CardCap()) &&
    (Table[i].CreateMode == CreateMode)) {
      return Table[i].result;
    }
  }
  return 0;
}
  
static void SwitchTo(char lines)
{
  union REGS cpu;
  int PriorCursor;
  
  // sets the video card to the specified number of rows if possible
  if (lines > 0) {
    PriorCursor = *(char*) MK_FP(0,0x460);
    if (lines == 25)
#ifndef _MSC_VER
      textmode(C80);
    else
      textmode(C4350);
#else
    _setvideomoderows(_DEFAULTMODE, 25);
    else
      _setvideomoderows(_DEFAULTMODE, _MAXTEXTROWS);
#endif
    if (PriorCursor == 0x2020) { // turn it back off
      cpu.x.ax = 0x0100;
      cpu.x.cx = 0x2020;
      int86(0x10, &cpu, &cpu);
    }
  }
}
  
void HandleLineMode(char ScreenRows, char CreateMode)
{
  switch (LineSwitchMode) {
    case SemiAutomatic:
      if (((unsigned char) ScreenRows > MaxAvailRows()) &&
        (MaxAvailRows() < (unsigned char) CardCap()))
        SwitchTo(CardCap());
      break;
    case Automatic:
      SwitchTo(SwitchTableResult(ScreenRows,CreateMode));
      break;
  }
}
