/* filename: POPSQZ.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <errno.h>
#include <share.h>
#include <vidpop.h>
  
int ScreenVersion(HeaderIDType * data);
int OffsetToSqz(SqzHeaderType * data);
unsigned SizeOfSqz(SqzHeaderType * data);
int LoadSqzBuffer(FILE * file, char * filename, long fileoffset,
int size, void ** buffer);
  
void PopSqz(char * FileName)
{
  int    DataLoaded;
  void   *SqzData = NULL;
  SqzHeaderType *SqzHeader;
  unsigned  SqzSize;
  FILE   *file;
  char   FileNameExt[STRSIZ], *p;
  struct stat statbuf;
  
  strcpy(FileNameExt, FileName);
  strcpy(FileNameExt, AddExt(FileNameExt,"SQZ"));
  ScreenFound = FALSE;
  if ((file = _fsopen(FileNameExt, "rb", SH_DENYWR)) != NULL) {
    if ((SqzHeader = malloc(sizeof(SqzHeaderType))) == NULL)
      SetError(217, 3, Insufficient_memory, to_load_sqz_file, FileNameExt);
    else {
      /*  The memory allocated for the SqzHeader buffer below is returned
      by the Load..Buffer functions in the following CASE statement.
      The Load..Buffer function builds a new buffer (SqzData) that has
      the Header data, Screen data and Get data.  So it returns
      the Header buffer so it can reuse that storage if necessary.  */
      if (sizeof(SqzHeaderType) != fread(SqzHeader, 1, sizeof(SqzHeaderType), file)) {
        SetError(0, 2, Error_reading_SQZ_file_data, FileNameExt);
        free(SqzHeader);
      }
      else {
        DataLoaded = FALSE;
        fstat(fileno(file), &statbuf);
        SqzSize = (unsigned) statbuf.st_size;
        switch (ScreenVersion((HeaderIDType * ) SqzHeader)) {
          /*  SqzSize is calculated as the buffer size needed.
          If the user has specified a "Get" processing routine,
          then it is the whole file.  If not, then we only need
          to read in the Header information up to the SQZ data,
          AND the SQZ data.  That is, all the data contained in
          the "OffsetToSqz" area, plus the SizeOfSqz area.  */
          case 4:        //  NO break; in this case !!!!
            if (!UserGetProc)
              SqzSize = OffsetToSqz(SqzHeader) + SizeOfSqz(SqzHeader);
          case 3:
            free(SqzHeader);
            DataLoaded = LoadSqzBuffer(file, FileName, 0, SqzSize, &SqzData);
            break;
          default:
            SetError(0, 3, Invalid_saywhat_sqz_format, found_in, FileNameExt);
            free(SqzHeader);
        }
        if (DataLoaded) {
          ScreenFound = TRUE;
          PopScreen(SqzData);
          free(SqzData);
        }
      }
    }
    fclose(file);
  }
  else {
    switch (errno) {
      case 3:  p = Path_not_found; break;
      case 4:  p = Too_many_files; break;
      case 12: p = File_access_denied; break;
      case 15: p = Invalid_drive_number; break;
      case 2:
      default: p = not_found;
    }
    SetError(errno, 2, FileNameExt, p);
  }
}
