/* filename: POPLIBMM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <vidpop.h>
  
void MakeName8(String8 Target, String8 temp);
long BCD2LongInt (ThreeByteInteger x);
  
void PopLibMem(LibraryHeader * Library, char *TargetScreen)
{
  int     Position, LowerLimit, UpperLimit, priorposition;
  directory_record *DirectoryPointer;
  V3HeaderType * Data_Pointer = NULL;
  char    temp[8];
  
  ScreenFound = FALSE;
  // should check version number !
  MakeName8(TargetScreen, temp);
  DirectoryPointer = (directory_record *) ((char *) Library + sizeof(LibraryHeader));
  // binary search
  UpperLimit = 0;
  LowerLimit = Library->NumberOfScreens;
  Position = 0;
  do {
    priorposition = Position;
    Position = (UpperLimit+LowerLimit)/2 + (UpperLimit+LowerLimit)%2;
    if (strncmp(temp, DirectoryPointer[Position].Name, 8) < 0)
      LowerLimit = Position;
    else
      UpperLimit = Position;
  }  while (!(Position == priorposition));
  --Position;
  // if screen is in library then pop it
  if (strncmp(temp, DirectoryPointer[Position].Name, 8) == 0) {
    Data_Pointer = (V3HeaderType *) ((long) Library + BCD2LongInt(DirectoryPointer[Position].Pointer));
    PopScreen(Data_Pointer);
  }
  else
    SetError(2, 4, error_screen, TargetScreen,
    not_found_in_linked_screen_library, " [PopLibMem]");
}
