/* filename: POPLIB.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <share.h>
#include <string.h>
#include <vidpop.h>
  
int ScreenVersion(HeaderIDType * DataPointer);
void MakeName8(String8 Target, String8 temp);
long BCD2LongInt (ThreeByteInteger x);
int LoadSqzBuffer(FILE * TheFile, char * FileName, long FileOffset,
int TheSize, void ** TheBuffer);
unsigned SizeOfSqz(SqzHeaderType * DataPointer);
unsigned OffsetToSqz(SqzHeaderType * DataPointer);
  
static char _tzfar funcname[] = { " [PopLib]" };
  
void PopLib(char which, char *TargetScreen)
{
  int   DataLoaded;
  long  FileOffset;
  int   LowerLimit, UpperLimit;
  char  temp[9];
  int   priorposition, Position;
  void  * SqzHeader, * SqzData = NULL;
  unsigned  SqzSize;
  library_array_record *v;
  
  ScreenFound = FALSE;
  if (LibraryArray[--which] == NULL)
    return;
  if (!LibraryArray[which]->LibraryOpen)
    return;
  // make sure target screen name is uppercase
  // pad target screen name with spaces to a length of 8
  MakeName8(TargetScreen, temp);
  v = LibraryArray[which];
  // binary search of directory for match to target screen
  UpperLimit = 0;
  LowerLimit = v->Header->NumberOfScreens;
  Position = -1;
  do {
    priorposition = Position;
    Position = (UpperLimit+LowerLimit)/2 + (UpperLimit+LowerLimit)%2;
    if (strncmp(temp, v->LibraryDirectory[Position]->Name, 8) < 0)
      LowerLimit = Position;
    else
      UpperLimit = Position;
  }  while (!(Position == priorposition));
  --Position;
  // if the screen name is found in directory then display the screen
  if (strncmp(temp, v->LibraryDirectory[Position]->Name, 8) == 0) {
    ScreenFound = FALSE;
    if (!v->KeepOpen)  {
      v->LibraryOpen = ((v->LibraryFile = _fsopen(v->Filename, "rb",
      SH_DENYWR)) != NULL) ? TRUE : FALSE;
      if (!v->LibraryOpen) {
        SetError(errno, 3, error_unable_to_re_open_screen_library_file,
        v->Filename, funcname);
        return;
      }
    }
    // read the screen data from the library file into a buffer
    FileOffset = BCD2LongInt(v->LibraryDirectory[Position]->Pointer);
    if (fseek(v->LibraryFile, FileOffset, SEEK_SET)) {
      SetError(errno, 3, error_corrupted_screen_library_file, v->Filename, funcname);
      return;
    }
    if ((SqzHeader = malloc(sizeof(SqzHeaderType))) == NULL)
      SetError(217, 3, Insufficient_memory, to_load_sqz_file, TargetScreen);
    else {
      // The memory allocated for the SqzHeader buffer below is returned
      // by the Load..Buffer functions in the following CASE statement.
      // The Load..Buffer function builds a new buffer (SqzData) that has
      // the Header data, Screen data and Get data.  So it returns
      // the Header buffer so it can reuse that storage if necessary.
      if (sizeof(SqzHeaderType) != fread(SqzHeader, 1, sizeof(SqzHeaderType), v->LibraryFile)) {
        free(SqzHeader);
        SetError(errno, 2, Error_reading_SQZ_file_data, v->Filename);
      }
      DataLoaded = FALSE;
      SqzSize = v->LibraryDirectory[Position]->Size;
      switch (ScreenVersion(SqzHeader)) {
        // SqzSize is calculated as the buffer size needed.
        // If the user has specified a "Get" processing routine,
        // then it is the whole Sqz screen data.  If not, then
        // we only need the Header information up to the SQZ
        // data, AND the SQZ data.  That is, all the data
        // contained in the "OffsetToSqz" area, plus the SizeOfSqz area.
        case 4:
          if (!UserGetProc)
            SqzSize = OffsetToSqz(SqzHeader) + SizeOfSqz(SqzHeader);
        case 3:
          free(SqzHeader);
          DataLoaded = LoadSqzBuffer(v->LibraryFile, TargetScreen,
          FileOffset, SqzSize, &SqzData);
          break;
        default:
          SetError(0, 3, Invalid_saywhat_sqz_format, found_in, TargetScreen);
          free(SqzHeader);
          break;
      }
      if (DataLoaded) {
        ScreenFound = TRUE;
        PopScreen(SqzData);
        free(SqzData);
      }
    }
    if (!v->KeepOpen)
      fclose(v->LibraryFile);
  }
  else
    SetError(2, 5, error_screen, TargetScreen,
    not_found_in_screen_library_file, v->Filename, funcname);
}
