/* filename: MNPSHPOP.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <vidpop.h>
  
void PushMenu(void)
{
  MenuPtr ThisMenu;
  
  if ((ThisMenu = malloc(sizeof(MenuRecord))) == NULL) {
    SetError(217, 2, Insufficient_memory, " [PushMenu]");
    return;
  }
  ThisMenu->MenuSeed = MenuSeed;
  ThisMenu->MenuChoice = MenuChoice;
  ThisMenu->MenuChar = MenuChar;
  ThisMenu->MenuKey = MenuKey;
  strcpy(ThisMenu->MenuString, MenuString);
  ThisMenu->MenuEscapeEnable = MenuEscapeEnable;
  ThisMenu->MenuHelpProc = MenuHelpProc;
  ThisMenu->MenuFKeyProc = MenuFKeyProc;
  ThisMenu->MenuBarAttr = MenuBarAttr;
  ThisMenu->PriorMenu = MenuStackPtr;
  MenuStackPtr = ThisMenu;
  // when the programmer calls PushMenu, he's starting a new
  // menu, so reset the seed and the help proc pointer
  MenuSeed = 1;
  MenuHelpProc = NULL;
  MenuFKeyProc = NULL;
}
  
void PopMenu(void)
{
  MenuPtr PriorMenu;
  
  if (!MenuStackPtr)
    SetError(218, 2, Empty_Menu_Stack, " [PopMenu]");
  else {
    MenuSeed = MenuStackPtr->MenuChoice; // note..this is NOT a mistake
    MenuChoice = MenuStackPtr->MenuChoice;
    MenuChar = MenuStackPtr->MenuChar;
    MenuKey = MenuStackPtr->MenuKey;
    strcpy(MenuString, MenuStackPtr->MenuString);
    MenuEscapeEnable = MenuStackPtr->MenuEscapeEnable;
    MenuHelpProc = MenuStackPtr->MenuHelpProc;
    MenuFKeyProc = MenuStackPtr->MenuFKeyProc;
    MenuBarAttr = MenuStackPtr->MenuBarAttr;
    PriorMenu = MenuStackPtr->PriorMenu;
    free(MenuStackPtr);
    MenuStackPtr = PriorMenu;
  }
}
