/* filename: FILLWIND.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
#include <vidpop.h>
  
void FillWindow(unsigned char x1, unsigned char y1, unsigned char x2,
unsigned char y2, WindowRec  *w)
// Store screen in a buffer and return pointer and size of buffer.
// Uses current Turbo Window() coordinates if any coordinate = 255
{
  unsigned row, RowSize, Position;
  char * BufferIndex;
#ifndef _MSC_VER
  struct text_info ti;
  
  gettextinfo(&ti);
#else
  short left, top, right, bottom;
  
  _gettextwindow(&top, &left, &bottom, &right);
#endif
  
  if ((x1 == 255) || (y1 == 255) || (x2 == 255) || (y2 == 255)) {
#ifndef _MSC_VER
    w->c1 = ti.winleft + 1; // use current Turbo Window coordinates
    w->r1 = ti.wintop + 1;
    w->c2 = ti.winright + 1;
    w->r2 = ti.winbottom + 1;
#else
    w->c1 = left + 1;
    w->r1 = top + 1;
    w->c2 = right + 1;
    w->r2 = bottom + 1;
#endif
  }
  else  {
    w->c1 = x1;
    w->r1 = y1;
    w->c2 = x2;
    w->r2 = y2;
  }
  RowSize = ((w->c2 - w->c1) + 1) << 1; // bytes per row
  w->BufferSize = RowSize * ((w->r2 - w->r1) + 1);
  if ((w->BufferPtr = malloc(w->BufferSize)) == NULL) {
    SetError(217,3,Insufficient_memory,to_push_window," [PushWindow]");
    w->BufferPtr = NULL;
    w->BufferSize = 0;
    return;
  }
  BufferIndex = w->BufferPtr;
  w->SaveBuffer = FALSE;
  Position = ((w->r1 - 1) * MaxCols + (w->c1 - 1)) << 1;
  for (row = w->r1; row <= (unsigned) w->r2; row++) {
    MoveScreenData((char far *) MK_FP(BaseSeg, VideoOffset + Position),
    (char far *) BufferIndex, RowSize/2);
    Position += OneLineLength; // move to next row
    BufferIndex += RowSize;
  }
}
