;/* filename: CPUTYPE.ASM
;
;: T O P A Z for C :Ŀ
;                          Version 4.5  05/16/93                              
;                                                                             
; Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
; Unauthorized distribution or disclosure of this source code or modification 
;  or removal of this notice  constitutes a breach of the license agreement.  
;
;*/
; ͻ
;  Detect the processor type by Richard C. Leinecker 
;          From Dr.Dobb's journal, june 1993         
;         Modified by Oleg V. Katz SSI\Russia        
; Ķ
;  Build command :                                   
;      tasm /mx /zi cputype.asm                      
;  or                                                
;      masm /Mx /Zi cputype.asm;                     
; ͼ
_TEXT   SEGMENT PARA PUBLIC 'CODE'
        ASSUME  CS:_TEXT, DS:_TEXT

        PUBLIC  _CPUType

; This routine returns the processor type as an integer value
;
; C prototype:
;     int far CPUType(void);
;
; Returns:
;  0 - 8088
;  1 - 8086
;  2 - 80286
;  3 - 80386
;  4 - 80486
;
; Code assumes ES, AX, BX, CX and DX can be altered. If their contents
; must be preserved, then you.ll have to push and pop them

_CPUType PROC FAR

        push    es
        push    bx
        push    cx
        push    dx

        push    bp              ; Preserv bp
        mov     bp, sp          ; bp = sp
        push    ds              ; Preserv ds
        push    di              ; and di
        mov     ax, cs          ; Point ds
        mov     ds, ax          ; to _TEXT

        call    IsItAn8088      ; Returns 0 or 2

        cmp     al, 2           ; 2 = 286 or better
        jge     AtLeast286      ; Go to 286 and above code

        call    IsItAn8086      ; Returns 0 or 1

        jmp short ExitCPUType   ; Jump to exit code

AtLeast286:
        call    IsItAn286       ; See if it's a 80286

        cmp     al, 3           ; 4 and above for 386 and up
        jge     AtLeast386      ; Go to 386 and above code
        jmp short ExitCPUType   ; Jump to exit code

AtLeast386:
        call    IsItAn386       ; See if it's a 80386

ExitCPUType:
        pop     di              ; Restore di
        pop     ds              ; ds
        pop     bp              ; bp

        pop     dx
        pop     cx
        pop     bx
        pop     es

        ret

_CPUType ENDP


; Is it an 8088 ?
; Returns AX:
;  0 - 8088/8086
;  2 - 80286 and above

IsItAn8088 PROC

        pushf                   ; Preserve the flags

        pushf                   ; Push the flags so
        pop     bx              ; we can pop them into bx

        and     bx, 0fffh       ; Mask off buits 12-15
        push    bx              ; and pop put it back on the stack

        popf                    ; Pop value back into the flags
        pushf                   ; Push it back. 8088/8086 will
                                ; have bits 12-15 set
        pop     bx              ; Get value into bx
        and     bx, 0f000h      ; Mack all but bits 12-15

        sub     ax, ax          ; Set ax to 8088 value
        cmp     bx, 0f000h      ; See if the bits are still set
        je      Not286          ; jump if not

        mov     al, 2           ; Set for 286 and above

Not286:
        popf                    ; Restore the flags
        ret                     ; Return to caler

IsItAn8088 ENDP

; Is It an 8086 ?
; Returns AX:
;  0 - 8088
;  1 - 8086
;
; Code takes advantage of the 8088's 4-byte prefetch queues and 8086's
; 6-byte prefetch queues. By self-modifying the code at a location exactly
; 5 bytes away from IP, and determing if the modification took effect, you
; can deffirentiate between 8088s and 8086s.

IsItAn8086 PROC

        mov     ax, cx          ; ES = code segment
        mov     es, ax

        std                     ; Cause stosb to count backwards

        mov     dx, 1           ; dx is flag and we'll start at 1
                                ; di = offset of code tail to modify
        mov     di, OFFSET EndLabel
        mov     al, 090h        ; al = NOP instruction code
        mov     cx, 3           ; Set for 3 repetitions
        rep     stosb           ; Setore the bytes

        cld                     ; Clear the direction flag
        nop                     ; Three nop in a row
        nop                     ; provide dummy instructions
        nop
RestoreLabel:
        dec     dx              ; Decrement flags (only with 8088)
        nop                     ; Dummy instruction - 6 bytes
EndLabel:
        nop

        cld                     ; di = offset of code modify
        mov     di, OFFSET RestoreLabel
        mov     al, 04ah        ; ax = DEC DX instruction code
        stosb                   ; Restore the byte

        mov     ax, dx          ; Store falg in ax
        ret                     ; Return to caler

IsItAn8086 ENDP

; Is it an 80286 ?
; Determing whether processor is a 286 or higher. Going into subroutine AX = 2
; If the processor is a 386 or higher, AX will be 3 before returning. The
; method is to set AX to 7000h which represent 386/486 NT and IOPL bits
; This value is pushed onto the stack and poped into the flags (with popf).
; The flags are then pushed back onto the stack (with pushf). Only a 386 or
; 486 will keep the 7000h bits set. If it's a 286, those bits aren't defined
; and when the flags are pushed onto stack these bits will be 0. Now, when AX
; is popped these bits can be checked. If they's set, we have a 386 or 486.

IsItAn286 PROC

        pushf                   ; Preserv the flags
        mov     ax, 7000h       ; Set NT and IOLP flags bits only
                                ; available for 386 prpcessors and above
        push    ax              ; Push ax so we can pop 7000h
                                ; into the flags register
        popf                    ; Pop 7000h off of the stack
        pushf                   ; Push the flag back on
        pop     ax              ; Get the pushed flag inti ax

        and     ah, 70h         ; See if the NT and IOPL flags are still set

        mov     ax, 2           ; Set ax to the 286 value
        jz short YesItIsAn286   ; If NT and IOPL not set it's a 286

        inc     ax              ; ax now is 4 to indicate 386 or higher

YesItIsAn286:
        popf                    ; Restore flags
        ret                     ; Return to caler

IsItAn286 ENDP

; Is it an 80386 or 80486 ?
; Determines whether processor is a 386 or higher. Going into subroutines
; ax = 3 if the processor is a 486, ax will be 4 before leaving. The method
; is to set the AC bit of the flags via EAX and stack. If stays set, it's a
; 486.

IsItAn386 PROC

        mov     di, ax          ; Store processor type
        mov     bx, sp          ; Save SP
        and     sp, 0fffch      ; Prevent aligment fault
.386
        pushfd                  ; Preserve the flags
        pushfd
        pop     eax             ; Get flags into EAX
        or      eax, 40000h     ; Set AC bit
        push    eax             ; Push back on the stack
        popfd                   ; Get the value into flags
        pushfd                  ; Put the value back on stack
        pop     eax             ; Get value into eax
        test    eax, 40000h     ; See if the bit is set
        jz      YesItIsAn386    ; If not we have a 386

        inc     di              ; Increment to indicate 486

YesItIsAn386:
        popfd                   ; Restore flags
.8086
        mov     sp, bx          ; Restore SP
        mov     ax, di          ; Put processor value into AX
        ret                     ; Return to caler

IsItAn386 ENDP

_TEXT     ENDS
          END
