/* filename: VFILEINI.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <vfiles.h>

int EmsInstalled = FALSE;  // Flag indicating if EMS is available
int ExtInstalled = FALSE;  // True if the EXT driver is available

// Expanded Memory Variables

unsigned int CurrentEmsPage = 0;        // Current Page, EMSPageArray index
unsigned char EmsError = 0;             // Error value if there was an EMS error
EmsFreeListBuffer *EmsFreeList = NULL;  // EMS free list data array
int EmsFreeListCount = 0;               // Number of EMS free list array entries
unsigned int EmsFreeListHandle = 0;     // Handle to the Free List memory
ArrayOfEmsPages *EmsPageArray = NULL;   // Holds EMS page assignments
char *EmsPageBuffer = NULL;             // Working EMS Buffer
int EmsPageCount = 0;                   // Number of EMS pages allocated
void *EmsPagePointer = NULL;            // Base pointer to EMS Page Frame
int EmsPagesAllowed = 0;                // Number of EMS pages allowed
int MaxEmsFreeList = 0;                 // Maximum EMS free list size
unsigned int WorkingEmsPage = 0;        // Working Page, EMSPageArray index

// Extended Memory Variables

unsigned int CurrentExtPage = 0;        // Current Page, ExtPageArray index
void *ExtDriver = NULL;                 // Address of the EXT HiMem.Sys driver
unsigned char ExtError = 0;             // Error value if there was an EXT error
ExtFreeListBuffer *ExtFreeList = NULL;  // EXT free list data array
int ExtFreeListCount = 0;               // Number of EXT free list array entries
unsigned int ExtFreeListPage = 0;       // EXT free list, element 0 of page array
ExtMoveParams *ExtMoveInfo = NULL;      // Data required to move EXT blocks
LLItemPtr ExtPackList = NULL;           // List of nodes to Pack to EXT Free List
ArrayOfExtPages *ExtPageArray = NULL;   // Holds Ext page assignments
char *ExtPageBuffer = NULL;             // Working Ext Buffer
int ExtPageCount = 0;                   // Number of EXT pages allocated
int ExtPageModified = FALSE;            // True if Current page has been modified
int ExtPagesAllowed = 0;                // Number of EXT pages allowed
int ExtWasSetup = FALSE;                // False until EXT is actually used
int MaxExtFreeList = 0;                 // Maximum EXT free list size
unsigned int WorkingExtPage = 0;        // Working Page, ExtPageArray index
void *ExtPagePointer = NULL;            // Base pointer to the EXT page working area

// General Use Variables

int AlreadyExited = 0;               // True when the Exit Proc returns handles
int ClosingFile = 0;                 // Flag indicating File is being Closing
LLItemPtr CurrentRecPtr = NULL;      // Current Linked List node pointer
DataStorageType DataLocation = Best; // Data buffer pointer type def
LLItemPtr HeadPtr = NULL;            // Linked List Head node pointer
LLItemPtr TailPtr = NULL;            // Linked List Tail node pointer
void *UserRecPtr = NULL;             // Pointer to User's data buffer
int VariableLength = 0;              // Flag indicating variable length records
// The following initializations are done so that the AvailableStorage
// function will return the correctly calculated values prior to
// using any storage.
unsigned int NextFreeExtByte = EXTPAGESIZE + 1; // Next available byte in the Ext buffer
unsigned int NextFreeEmsByte = EMSPAGESIZE + 1; // Next available byte in the EMS buffer

void TZVFilesInit(void)
{
  atexit(MemoryManagementExitProc);

  LLRoutines = (void (*)(void *)) ActionLL;

  // In the initialization code below, EMS is initialized prior to EXT because
  // the EMS "Windows" are 16K pages that are potentially taken out of EXT
  // memory.  So we setup EMS first, so that when we setup EXT, the amount
  // of available memory will be correctly calculated.
#ifdef WINDOWS
  EmsInstalled = FALSE; // Windows or DPMI programs will use the heap only
  ExtInstalled = FALSE;
#else
  EmsInstalled = EmsPresent(); // This initializes the EMS PageFramePtr
  if(EmsInstalled)
    if(GetAvailEmsPages() <= 4) // 4 = at least 1 EMS page for the user to use,
      EmsInstalled = FALSE;    // and 3 EMS pages to keep track of the free list info.
    else
      SetupEmsFreeList(); // Sets up the Free List 3 page handle.

  ExtInstalled = ExtPresent(); // True if the HiMem.Sys driver's present

  if(ExtInstalled)
    if(GetAvailExtKbytes() <= (2 * (unsigned int) KBPEREXTPAGE))
      // 2 = at least 1 EXT page for the user to use, and 1 EXT page to keep
      // track of the free list info.
      ExtInstalled = FALSE;

#endif // {{ WINDOWS }}

  // We don't setup the free list now, because it requires stack space, &
  // the user may not use EXT at all!! It's done in the OpenStorage routine
}
