/* filename: AVAILMEM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef WINDOWS
#include <windows.h>
#endif
#include <vfiles.h>

extern unsigned int NextFreeEmsByte;
extern unsigned int NextFreeExtByte;

long AvailableMemory(char *MemoryType)
// This function returns the amount of storage available for the type of
// memory indicated by MemoryType.  This is basically the same function
// accomplished by the FreeSpace function, except with the function, you
// specify which type of memory you are interested in, so you can decide
// which area to use prior to opening a file. */
{
  char type[12];

  strcpy(type, MemoryType);
  strupr(type);

  if(strstr(type, "BEST"))
    strcpy(type, EvaluateBest());
  else
    if(strstr(type, "BIGGEST"))
      strcpy(type, EvaluateBiggest());

  if(strstr(type, "HEAP"))
#ifdef WINDOWS
    return (long) GetFreeSpace(0);
#else
    return (long) coreleft();
#endif

  if(strstr(type, "EMS")) {
    if(EmsInstalled)
      return (long) GetAvailEmsPages() * (long) EMSPAGESIZE +
             (long) (EMSPAGESIZE - NextFreeEmsByte + 1);
    else
      return 0L;
  }

  if(strstr(type, "EXT") || strstr(type, "XMS")) {
    if(ExtInstalled)
      return (long) GetAvailExtKbytes() * 1024L +
             (long) (EXTPAGESIZE - NextFreeExtByte + 1);
    else
      return 0L;
  }

  if(strstr(type, "DISK"))
    return _wm_getdiskfreespace(0);

  return 0L;
}
