/* filename: ADDSTRU.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <vfiles.h>

void AddStru(FieldArray FieldList, unsigned char FieldCount)
{
  WorkAreaType *wa;
  dbfRecord    *r;
  unsigned char i;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  if(NotInUseError("AddStru")) // check current area
    return;
  if(r->v.strue.LinkedList) {
    // if field list has memo field(s) then convert them to long fields
    for(i = 0; i < FieldCount; i++)
      if(FieldList[i].Typ == 'M') {
        FieldList[i].Typ = 'N';
        FieldList[i].Len = 10;
        FieldList[i].Dec = 0;
      } // If there's already a structure defined, free it
    if(r->Fields) {
      FreePtrClear((void*) &r->Fields);
      r->NumFields = 0;
    } // get memory and then copy structure into buffer
    r->Fields = (FieldRecord *) malloc(FieldCount * sizeof(FieldRecord));
    if(!r->Fields) {
      SetError(InsufficientMemory, 3, Not_Enough_Memory_To_Create_Stru,
               wa->Alias, " [AddStru]");
      return;
    }
    memcpy(r->Fields, &FieldList, (size_t) FieldCount * sizeof(FieldRecord));
    r->NumFields = FieldCount;
  } else
    SetError(InvalidLLOperation, 3, wa->Alias, is_not_a_virtual_file, " [AddStru]");
}

void CreateStru(FieldArray FieldList, unsigned char FieldCount)
{
  AddStru(FieldList, FieldCount);
}
