/* filename: PLURAL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>

extern char _tzfar _tz_buffer[];

static char *MakePlural(char *s, char *buff)
{
  int  l, isvowel;
  char Vowels[] = "AEIOU";
  char ending[] = "es" ;
  char *p, prev;

  p = ending;
  l = strlen(s) - 1;
  prev = UpCase(s[l - 1]);
  isvowel = strchr(Vowels, prev) != NULL;
  strcpy(buff, s);
  switch(UpCase(s[l])) {
    case 'O':
      if(isvowel)
        ++p; // rule # 1
      break;

    case 'S':
    case 'X':
    case 'Z': // rule # 3
      break;

    case 'H': // rule # 3 (starch -> starches)
      if(prev != 'C')
        ++p;
      break;

    case 'Y':
      if(!isvowel) // rule # 4 (copy --> copies)
        s[l] = 'i';
      else
        ++p;
      break;

    default: // rule #5,#6, etc.
      ++p;
      break;
  }

  return strcat(buff, p);
}

/*
    Guide to plurals for the English language:
 1. If RootWord ends in an "o" and is preceded by a vowel, always add an "s"
 2. If RootWord ends in an "o" and is preceded by a consonant, add an "es"
    (although musical terms, and some other nouns still take only "s")
 3. If RootWord ends in "s", "x", "ch", and "z", add an "es".
 4. If RootWord ends in "y" and is preceded by a consonant, change the "y" to
    and "i" and add "es".
 5. If RootWord ends in "y" and is preceded by a vowel, add an "s".
 6. If RootWord ends in "ful", add an "s".
 7. Latin and Greek terms are pluralized differently (curriculum ->
    curricula) and depend on the gender of the term (alumnus->alumni,
    but alumna -> alumnae).  Since we can't know what language RootWord
    is from, we don't deal with these problems.
*/
char *Plural(long Count, char *RootWord)
{
  char buff[STRSIZ];

  if(Count == 1) {
    strcpy(_tz_buffer, "1 ");
    strcat(_tz_buffer, RootWord);
  } else {
    MakePlural(RootWord, buff);
    if(Count == 0) {
      strcpy(_tz_buffer, "No ");
      strcat(_tz_buffer, buff);
    } else {
      strcpy(_tz_buffer, SInteger(Count, 0));
      strcat(_tz_buffer, " ");
      strcat(_tz_buffer, buff);
    }
  }
  return _tz_buffer;
}
