/* filename: FILEAGE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <time.h>
#include <utils.h>

BOOL FileAge(char *fname, struct DateTime *Age)
// returns the age of file given a file name. result is returned in the Age.
// Success is set to FALSE if the file does not exist.
{
  long        sex;
  struct stat st;

  memset(Age, 0, sizeof(DateTime));

  if(!stat(fname, &st)) {
    sex = (long) (time(NULL) - st.st_ctime);

    Age->Day = (unsigned) (sex / 86400L); // number of days = sex / (60s*60m*24h)
    sex -= Age->Day * 86400L;

    Age->Hour = (unsigned) (sex / 3600L); // number of hours
    sex -= Age->Hour * 3600L;

    Age->Min = (unsigned) (sex / 60L); // number of minutes
    sex -= Age->Min * 60L;

    Age->Sec  = (unsigned) sex;

    return TRUE;
  } else
    return FALSE;
}
