/* filename: COUNT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <dbf.h>
#include <sayget.h>
#include <timedate.h>
#include <utils.h>

#define LOCATE 0
#define COUNT  1

extern int FieldForContinue;
extern char _tzfar   SForContinue[];

char _tzfar _tz_FieldName[11] = "";
int  _tz_CaseSensitive = FALSE;
int  _tz_Exact         = FALSE;
int  _tz_Contained     = FALSE;

#ifndef WINDOWS
void wmUpdateProgress(void);
#endif

long wmCount(char *FieldName, void *FieldValue, int fl)
{
  char SearchString[STRSIZ];
  char FieldContent[STRSIZ], *ptr;
  int  Width, NotMemo, i;
  long Counter, recs, j;

  ParseFieldName(FieldName);
  i = FieldNo(_tz_FieldName);
  switch(FieldType(i)) {
    case 'M':
    case 'C':
      ptr = (char *) FieldValue;
      break;

    case 'L':
      ptr = *((int *) FieldValue) ? "T" : "F";
      break;

    case 'D':
      ptr = CtoD((char *) FieldValue);
      break;

    case 'N':
    case 'F':
      ptr = FieldDec(i) ? SReal(*(long double *) FieldValue, FieldLen(i), FieldDec(i))
                        : SInteger(*((long *) FieldValue), FieldLen(i));
      break;
  }
  strcpy(SearchString, ptr);

  if(!_tz_Exact)
    strcpy(SearchString, Trim(SearchString));

  if(!_tz_CaseSensitive)
    UpperCase(SearchString);
  Width = strlen(SearchString);

  if(fl == COUNT)
    Counter = 0;
  else {
    FieldForContinue = i;
    strcpy(SForContinue, SearchString);
  }

  NotMemo = (FieldType(i) != 'M');
  recs = RecCount();

  for(j = 1L; j <= recs; j++ ) {
    strcpy(FieldContent, Peek(i,j));
    if(NotMemo) {
      if(!(_tz_Exact || _tz_Contained))
        FieldContent[Width] = 0;

      if(!_tz_CaseSensitive)
        UpperCase(FieldContent);

      if((_tz_Contained && strstr(FieldContent, SearchString)) ||
         (!_tz_Contained && !strcmp(FieldContent, SearchString)))
        if(fl == COUNT)
          Counter++;
        else {
          Go(j);
          return 0;
        }
    } else
      if(InMemo(SearchString, FieldContent))
        if(fl == COUNT)
          Counter++;
        else {
          Go(j);
          return 0;
        }
#ifndef WINDOWS
    if(fl == COUNT)
      wmUpdateProgress();
#endif
  }
  if(fl == LOCATE) {
    GoBottom();
    if(RecCount())
      Skip(1);   // don't skip on an empty database!
    FieldForContinue = 0;
    return 0L;
  } else
    return Counter;
}

long Count(char *FieldName, void *FieldValue)
{
  return wmCount(FieldName, FieldValue, COUNT);
}
