/* filename: SETALTTO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <sayget.h>
#include <tzprint.h>
#ifdef WINDOWS
#include <windows.h>
#endif
  
char _tzfar AlternateName[80]  = "";
int AlternateOn  = FALSE;
int AlternateOpen  = FALSE;
FILE * Alt = NULL; // required to write to alternate device
  
void SetAlternateTo(const char * filename)
{
  int appendclause = FALSE;
  char * posofspace;
#ifdef WINDOWS
  char wtemp[150];
#else
  char answer;
#endif
  
  if (AlternateOpen) {
    fclose(Alt);
    AlternateOpen = FALSE;
    AlternateOn = FALSE;
  }
  strcpy(AlternateName, Trim(Ltrim(filename)));
  if (!*AlternateName)
    return;
  UpperCase(AlternateName);
  /* filename will be first string..
  there may be an APPEND clause second.. look for it */
  posofspace = strchr(AlternateName, ' ');
  if (posofspace) { // seems there is a clause to test
    appendclause = (strstr(posofspace, "APPEND" ) != NULL );
    // remove the clause or whatever it is
    *posofspace = 0;
  }
  // add default extension if possible
  strcpy(AlternateName, (const char *)AddExt((AlternateName),"TXT"));
  
  // if the file is new, there can be no appending
  if (access(AlternateName,0))
    appendclause = FALSE;
  else {
    if (SafetyOn && (!appendclause)) {
      // ask if they want to overwrite the file if it already exists
#ifdef WINDOWS
      sprintf(wtemp, "%s%s", Overwrite_file, AlternateName);
      if (WDialogBox(wtemp,"",MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
        return;
#else
      printf("\n%s%s%s",Overwrite_file,AlternateName,question_y_n);
      do {
        answer = UpCase(getch());
      } while ((answer != yes) && (answer != no));
      printf("\n");
      if (answer == no)
        return;
#endif
    }
  }
  Alt = fopen(AlternateName, appendclause ? "a+" : "w");
  if (!Alt) {
    SetError(errno,2,Error_creating_alternate_file, AlternateName);
    *AlternateName = 0;
    AlternateOpen = FALSE;
  }
  else {
    AlternateOpen = TRUE;
    DBFError = 0;
  }
}
